/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.timed;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartDelayedAction;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraftforge.common.util.ForgeDirection;

public class PartRepeater
extends PartDelayedAction {
    public final PropertyStitcher.IntProperty PROP_DELAY;
    public final PropertyStitcher.BooleanProperty PROP_OUT;

    public PartRepeater() {
        this.PROP_DELAY = new PropertyStitcher.IntProperty("DELAY", this.stitcher, 255);
        this.PROP_OUT = new PropertyStitcher.BooleanProperty("OUT", this.stitcher);
    }

    @Override
    protected int getDelay(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_DELAY);
    }

    @Override
    public void onPlaced(Vec2 pos, ICircuit parent) {
        this.setProperty(pos, parent, this.PROP_DELAY, 1);
        super.onPlaced(pos, parent);
    }

    @Override
    public void onClick(Vec2 pos, ICircuit parent, int button, boolean ctrl) {
        super.onClick(pos, parent, button, ctrl);
        if (button == 0 && ctrl) {
            int delay = this.getProperty(pos, parent, this.PROP_DELAY);
            if ((delay = delay * 2 + 1) > 255) {
                delay = 1;
            }
            this.setProperty(pos, parent, this.PROP_DELAY, delay);
            this.markForUpdate(pos, parent);
        }
    }

    @Override
    public boolean canConnectToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        return s2 == ForgeDirection.NORTH || s2 == ForgeDirection.SOUTH;
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        if (s2 != ForgeDirection.NORTH) {
            return false;
        }
        return this.getProperty(pos, parent, this.PROP_OUT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(1, 1);
    }

    @Override
    public void onDelay(Vec2 pos, ICircuit parent) {
        this.invertProperty(pos, parent, this.PROP_OUT);
        this.notifyNeighbours(pos, parent);
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        boolean checkInput = !this.isDelayActive(pos, parent);
        super.onScheduledTick(pos, parent);
        if (checkInput && this.getProperty(pos, parent, this.PROP_OUT).booleanValue() != this.getInputFromSide(pos, parent, this.toExternal(pos, parent, ForgeDirection.SOUTH))) {
            this.setDelay(pos, parent, true);
        }
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList<String> list = super.getInformation(pos, parent, edit, ctrlDown);
        list.add("Delay: " + (this.getProperty(pos, parent, this.PROP_DELAY) + 1));
        return list;
    }
}

