/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.timed;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.IConfigurableDelay;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartDelayedAction;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraftforge.common.util.ForgeDirection;

public class PartSequencer
extends PartDelayedAction
implements IConfigurableDelay {
    public final PropertyStitcher.IntProperty PROP_OUTPUT_SIDE;
    public final PropertyStitcher.IntProperty PROP_DELAY;

    public PartSequencer() {
        this.PROP_OUTPUT_SIDE = new PropertyStitcher.IntProperty("OUTPUT_SIDE", this.stitcher, 3);
        this.PROP_DELAY = new PropertyStitcher.IntProperty("DELAY", this.stitcher, 255);
    }

    @Override
    protected int getDelay(Vec2 pos, ICircuit parent) {
        return this.getConfigurableDelay(pos, parent);
    }

    @Override
    public int getConfigurableDelay(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_DELAY);
    }

    @Override
    public void setConfigurableDelay(Vec2 pos, ICircuit parent, int delay) {
        this.setProperty(pos, parent, this.PROP_DELAY, delay);
    }

    @Override
    public void onPlaced(Vec2 pos, ICircuit parent) {
        this.setConfigurableDelay(pos, parent, 10);
        this.setDelay(pos, parent, true);
        super.onPlaced(pos, parent);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(3, 1);
    }

    @Override
    public void onDelay(Vec2 pos, ICircuit parent) {
        this.cycleProperty(pos, parent, this.PROP_OUTPUT_SIDE);
        this.setDelay(pos, parent, true);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        return MiscUtils.getDirection(this.getProperty(pos, parent, this.PROP_OUTPUT_SIDE)) == this.toInternal(pos, parent, side);
    }

    @Override
    public void getCraftingCost(CraftingAmount cost, CircuitData parent, Vec2 pos) {
        cost.add(new ItemAmount(Items.field_151137_ax, 0.15));
        cost.add(new ItemAmount(Items.field_151114_aO, 0.1));
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList<String> text = super.getInformation(pos, parent, edit, ctrlDown);
        if (edit && ctrlDown) {
            text.add(I18n.func_135052_a((String)"gui.integratedcircuits.cad.delay", (Object[])new Object[0]));
        }
        return text;
    }
}

