/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.timed;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.IConfigurableDelay;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartDelayedAction;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraftforge.common.util.ForgeDirection;

public class PartStateCell
extends PartDelayedAction
implements IConfigurableDelay {
    public final PropertyStitcher.IntProperty PROP_DELAY;
    private final PropertyStitcher.BooleanProperty PROP_OUT_WEST;
    private final PropertyStitcher.BooleanProperty PROP_OUT_NORTH;

    public PartStateCell() {
        this.PROP_DELAY = new PropertyStitcher.IntProperty("DELAY", this.stitcher, 255);
        this.PROP_OUT_WEST = new PropertyStitcher.BooleanProperty("OUT_WEST", this.stitcher);
        this.PROP_OUT_NORTH = new PropertyStitcher.BooleanProperty("OUT_NORTH", this.stitcher);
    }

    @Override
    public int getConfigurableDelay(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_DELAY);
    }

    @Override
    public void setConfigurableDelay(Vec2 pos, ICircuit parent, int delay) {
        this.setProperty(pos, parent, this.PROP_DELAY, delay);
    }

    @Override
    protected int getDelay(Vec2 pos, ICircuit parent) {
        if (this.getProperty(pos, parent, this.PROP_OUT_NORTH).booleanValue()) {
            return 2;
        }
        return this.getConfigurableDelay(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        if (s2 == ForgeDirection.WEST && this.getProperty(pos, parent, this.PROP_OUT_WEST).booleanValue()) {
            return true;
        }
        return s2 == ForgeDirection.NORTH && this.getProperty(pos, parent, this.PROP_OUT_NORTH) != false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(4, 1);
    }

    @Override
    public void onDelay(Vec2 pos, ICircuit parent) {
        if (this.getProperty(pos, parent, this.PROP_OUT_NORTH).booleanValue()) {
            this.setProperty(pos, parent, this.PROP_OUT_NORTH, false);
        } else {
            this.setProperty(pos, parent, this.PROP_OUT_WEST, false);
            this.setProperty(pos, parent, this.PROP_OUT_NORTH, true);
            this.setDelay(pos, parent, true);
        }
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public void onPlaced(Vec2 pos, ICircuit parent) {
        this.setProperty(pos, parent, this.PROP_DELAY, 20);
        super.onPlaced(pos, parent);
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        super.onScheduledTick(pos, parent);
        if (this.getInputFromSide(pos, parent, this.toExternal(pos, parent, ForgeDirection.SOUTH))) {
            this.setProperty(pos, parent, this.PROP_OUT_WEST, true);
            this.setProperty(pos, parent, this.PROP_OUT_NORTH, false);
            this.setDelay(pos, parent, false);
            this.notifyNeighbours(pos, parent);
        } else if (this.getProperty(pos, parent, this.PROP_OUT_WEST).booleanValue()) {
            if (this.getInputFromSide(pos, parent, this.toExternal(pos, parent, ForgeDirection.EAST))) {
                this.setDelay(pos, parent, false);
            } else if (!this.isDelayActive(pos, parent)) {
                this.setDelay(pos, parent, true);
            }
        }
    }

    @Override
    public void getCraftingCost(CraftingAmount cost, CircuitData parent, Vec2 pos) {
        cost.add(new ItemAmount(Items.field_151137_ax, 0.15));
        cost.add(new ItemAmount(Items.field_151114_aO, 0.1));
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList<String> text = super.getInformation(pos, parent, edit, ctrlDown);
        if (edit && ctrlDown) {
            text.add(I18n.func_135052_a((String)"gui.integratedcircuits.cad.delay", (Object[])new Object[0]));
        }
        return text;
    }
}

