/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.timed;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartDelayedAction;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraftforge.common.util.ForgeDirection;

public class PartSynchronizer
extends PartDelayedAction {
    public final PropertyStitcher.BooleanProperty PROP_IN_EAST;
    public final PropertyStitcher.BooleanProperty PROP_IN_WEST;
    public final PropertyStitcher.BooleanProperty PROP_OLD_EAST;
    public final PropertyStitcher.BooleanProperty PROP_OLD_WEST;

    public PartSynchronizer() {
        this.PROP_IN_EAST = new PropertyStitcher.BooleanProperty("IN_EAST", this.stitcher);
        this.PROP_IN_WEST = new PropertyStitcher.BooleanProperty("IN_WEST", this.stitcher);
        this.PROP_OLD_EAST = new PropertyStitcher.BooleanProperty("OLD_EAST", this.stitcher);
        this.PROP_OLD_WEST = new PropertyStitcher.BooleanProperty("OLD_WEST", this.stitcher);
    }

    @Override
    public int getDelay(Vec2 pos, ICircuit parent) {
        return 2;
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        super.onScheduledTick(pos, parent);
        ForgeDirection west = this.toExternal(pos, parent, ForgeDirection.WEST);
        boolean westIn = this.getInputFromSide(pos, parent, west);
        boolean eastIn = this.getInputFromSide(pos, parent, west.getOpposite());
        if (this.getInputFromSide(pos, parent, this.toExternal(pos, parent, ForgeDirection.SOUTH))) {
            this.setProperty(pos, parent, this.PROP_IN_EAST, false);
            this.setProperty(pos, parent, this.PROP_IN_WEST, false);
            this.setDelay(pos, parent, false);
            this.notifyNeighbours(pos, parent);
        } else if (!this.isDelayActive(pos, parent)) {
            if (westIn && !this.getProperty(pos, parent, this.PROP_OLD_WEST).booleanValue()) {
                this.setProperty(pos, parent, this.PROP_IN_WEST, true);
            }
            if (eastIn && !this.getProperty(pos, parent, this.PROP_OLD_EAST).booleanValue()) {
                this.setProperty(pos, parent, this.PROP_IN_EAST, true);
            }
            if (this.getProperty(pos, parent, this.PROP_IN_WEST).booleanValue() && this.getProperty(pos, parent, this.PROP_IN_EAST).booleanValue()) {
                this.setDelay(pos, parent, true);
                this.setProperty(pos, parent, this.PROP_IN_EAST, false);
                this.setProperty(pos, parent, this.PROP_IN_WEST, false);
                this.notifyNeighbours(pos, parent);
            }
        }
        this.setProperty(pos, parent, this.PROP_OLD_WEST, westIn);
        this.setProperty(pos, parent, this.PROP_OLD_EAST, eastIn);
    }

    @Override
    public void onDelay(Vec2 pos, ICircuit parent) {
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        if (s2 == ForgeDirection.NORTH) {
            return this.isDelayActive(pos, parent);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(10, 1);
    }
}

