/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.IGate;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.gate.Gate;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.net.Packet7SegmentOpenGui;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import org.apache.commons.lang3.StringUtils;

public class Gate7Segment
extends Gate {
    private final Cuboid6 dimensions = new Cuboid6(2.0, 0.0, 1.0, 14.0, 3.0, 15.0);
    public int digit = NUMBERS[0];
    public int color;
    public boolean isSlave;
    public boolean hasSlaves;
    public int mode = 0;
    public BlockCoord parent;
    public ArrayList<BlockCoord> slaves = Lists.newArrayList();
    public static final byte[] NUMBERS = new byte[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111, 119, 124, 57, 94, 121, 113};
    public static final byte[] TRUE = new byte[]{121, 62, 80, 120};
    public static final byte[] FALSE = new byte[]{121, 109, 56, 119, 113};
    public static final byte[] NAN = new byte[]{55, 119, 55};
    public static final byte[] INF = new byte[]{113, 55, 48};
    public static final byte[] INFINITY = new byte[]{110, 120, 48, 55, 48, 113, 55, 48};
    public static final int DOT = 128;
    public static final int SIGN = 64;
    public static final int MODE_SIMPLE = 0;
    public static final int MODE_ANALOG = 1;
    public static final int MODE_SHORT_SIGNED = 2;
    public static final int MODE_SHORT_UNSIGNED = 3;
    public static final int MODE_FLOAT = 4;
    public static final int MODE_BINARY_STRING = 5;
    public static final int MODE_MANUAL = 6;

    @Override
    public void preparePlacement(EntityPlayer player, ItemStack stack) {
        this.color = stack.func_77960_j();
    }

    @Override
    public void onActivatedWithScrewdriver(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (player.func_70093_af()) {
            CommonProxy.networkWrapper.sendTo((IMessage)new Packet7SegmentOpenGui(this.provider), (EntityPlayerMP)player);
        } else {
            super.onActivatedWithScrewdriver(player, hit, item);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.provider.getWorld().field_72995_K) {
            return;
        }
        this.isSlave = false;
        int abs = Rotation.rotateSide((int)this.provider.getSide(), (int)this.provider.getRotationAbs(3));
        BlockCoord pos = this.provider.getPos();
        BlockCoord pos2 = pos.copy();
        int off = 0;
        do {
            ++off;
            pos2.offset(abs);
            Gate7Segment seg = this.getSegment(pos2);
            if (seg == null || seg.provider.getRotation() != seg.provider.getRotation()) break;
            if (seg.isSlave) continue;
            this.parent = pos2;
            this.isSlave = true;
            seg.claimSlaves();
            seg.updateSlaves();
            break;
        } while (off < Config.sevenSegmentMaxDigits);
        this.sendChangesToClient();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!this.provider.getWorld().field_72995_K) {
            this.updateConnections();
        }
    }

    @Override
    public void onRotated() {
        this.updateConnections();
        this.claimSlaves();
    }

    public void updateConnections() {
        if (this.isSlave) {
            BlockCoord crd = this.provider.getPos();
            this.isSlave = false;
            Gate7Segment master = this.getSegment(this.parent);
            if (master != null) {
                master.claimSlaves();
            }
            int abs = Rotation.rotateSide((int)this.provider.getSide(), (int)this.provider.getRotationAbs(1));
            crd.offset(abs);
            Gate7Segment seg = this.getSegment(crd);
            if (seg != null) {
                seg.claimSlaves();
            }
        } else {
            Gate7Segment seg;
            int abs = Rotation.rotateSide((int)this.provider.getSide(), (int)this.provider.getRotationAbs(1));
            BlockCoord crd = this.provider.getPos().offset(abs);
            if (this.slaves.contains(crd) && (seg = this.getSegment(crd)) != null) {
                seg.claimSlaves();
            }
            this.slaves.clear();
        }
    }

    public void claimSlaves() {
        this.isSlave = false;
        this.slaves.clear();
        int abs = Rotation.rotateSide((int)this.provider.getSide(), (int)this.provider.getRotationAbs(1));
        BlockCoord pos = this.provider.getPos();
        BlockCoord pos2 = pos.copy();
        int off = 0;
        do {
            ++off;
            pos2.offset(abs);
            Gate7Segment seg = this.getSegment(pos2);
            if (seg == null || !seg.isSlave || seg.provider.getRotation() != this.provider.getRotation()) break;
            this.slaves.add(pos2.copy());
        } while (off < Config.sevenSegmentMaxDigits);
        this.updateSlaves();
        this.sendChangesToClient();
    }

    public Gate7Segment getSegment(BlockCoord crd) {
        ISocket socket = IntegratedCircuitsAPI.getSocketAt(this.provider.getWorld(), crd, this.provider.getSide());
        if (socket == null) {
            return null;
        }
        IGate gate = socket.getGate();
        if (gate instanceof Gate7Segment) {
            return (Gate7Segment)gate;
        }
        return null;
    }

    private void updateSlaves() {
        if (this.provider.getWorld().field_72995_K) {
            return;
        }
        int input = 0;
        if (this.mode == 0 || this.mode == 1) {
            if (this.mode == 0) {
                for (byte[] in : this.provider.getInput()) {
                    input |= in[0] != 0 ? (byte)1 : 0;
                }
            } else {
                for (byte[] in : this.provider.getInput()) {
                    if (in[0] <= input) continue;
                    input = in[0];
                }
            }
            if (this.slaves.size() < 4 || this.mode == 1) {
                this.writeDigits(null);
                this.writeDigit(NUMBERS[input]);
            } else {
                byte[] digits = input == 0 ? FALSE : TRUE;
                this.writeDigits(digits);
            }
        } else {
            boolean sign = false;
            int length = 16;
            for (byte[] in : this.provider.getInput()) {
                int i2 = 0;
                for (int i = 0; i < 16; ++i) {
                    i2 |= (in[i] != 0 ? 1 : 0) << i;
                }
                input |= i2;
            }
            boolean outOfBounds = false;
            int decimalDot = -1;
            String dispString = "";
            if (this.isSigned()) {
                sign = (input & 0x8000) != 0;
                input &= Short.MAX_VALUE;
            }
            if (this.mode == 6) {
                this.writeDigits(null);
                this.writeDigit(input & 0xFF);
                return;
            }
            if (this.mode == 4) {
                float conv = MiscUtils.toBinary16Float(input);
                if (Float.isNaN(conv) || Float.isInfinite(conv)) {
                    byte[] digits = null;
                    if (Float.isNaN(conv) && this.slaves.size() > 1) {
                        digits = NAN;
                    } else if (Float.isInfinite(conv)) {
                        if (this.slaves.size() > 7) {
                            digits = INFINITY;
                        } else if (this.slaves.size() > 2) {
                            digits = INF;
                        }
                    }
                    if (digits != null) {
                        Gate7Segment slave;
                        this.writeDigits(digits);
                        if (sign && Float.isInfinite(conv) && (slave = this.getSegment(this.slaves.get(this.slaves.size() - 1))) != null) {
                            slave.writeDigit(64);
                        }
                        return;
                    }
                    outOfBounds = true;
                } else {
                    int size = this.slaves.size() - String.valueOf((int)conv).length();
                    DecimalFormat df = new DecimalFormat("#", new DecimalFormatSymbols(Locale.ENGLISH));
                    df.setMaximumFractionDigits(size);
                    dispString = df.format(conv);
                    decimalDot = dispString.indexOf(".");
                    dispString = dispString.replace(".", "");
                    if (decimalDot != -1) {
                        decimalDot = dispString.length() - decimalDot;
                    }
                }
            } else {
                dispString = this.mode == 5 ? Integer.toBinaryString(input) : String.valueOf(input);
            }
            int size = dispString.length() - 1;
            if (size > this.slaves.size() - (this.isSigned() ? 1 : 0)) {
                outOfBounds = true;
            }
            dispString = StringUtils.reverse((String)dispString);
            for (int i = 0; i <= this.slaves.size(); ++i) {
                int decimal = i < dispString.length() ? Integer.valueOf(String.valueOf(dispString.charAt(i))) : 0;
                Gate7Segment slave = this;
                if (i > 0) {
                    BlockCoord bc = this.slaves.get(i - 1);
                    slave = this.getSegment(bc);
                }
                if (slave == null) continue;
                if (i == this.slaves.size() && this.isSigned()) {
                    slave.writeDigit(sign ? 64 : 0);
                    continue;
                }
                slave.writeDigit(outOfBounds ? 64 : NUMBERS[decimal] | (decimalDot == i ? 128 : 0));
            }
        }
    }

    private void writeDigits(byte[] digits) {
        for (int i = 0; i <= this.slaves.size(); ++i) {
            byte digit;
            Gate7Segment slave = this;
            byte by = digit = digits != null && i < digits.length ? digits[i] : (byte)0;
            if (i > 0) {
                BlockCoord bc = this.slaves.get(i - 1);
                slave = this.getSegment(bc);
            }
            if (slave == null) continue;
            slave.writeDigit(digit);
        }
    }

    private void writeDigit(int digit) {
        if (this.digit != digit) {
            this.digit = digit;
            this.provider.getWriteStream(10).writeInt(digit);
        }
    }

    private boolean isSigned() {
        return this.mode == 2 || this.mode == 4;
    }

    private void sendChangesToClient() {
        this.provider.notifyPartChange();
        this.hasSlaves = this.slaves.size() > 0;
        MCDataOutput out = this.provider.getWriteStream(11);
        out.writeBoolean(this.isSlave);
        out.writeBoolean(this.hasSlaves);
    }

    @Override
    public void updateInputPost() {
        super.updateInputPost();
        if (!this.isSlave) {
            this.updateSlaves();
        }
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.digit = tag.func_74762_e("display");
        this.isSlave = tag.func_74767_n("isSlave");
        this.color = tag.func_74762_e("color");
        this.mode = tag.func_74762_e("mode");
        if (this.isSlave) {
            this.parent = new BlockCoord(tag.func_74759_k("parent"));
        } else {
            this.slaves = Lists.newArrayList();
            NBTTagList slaves = tag.func_150295_c("slaves", 11);
            for (int i = 0; i < slaves.func_74745_c(); ++i) {
                this.slaves.add(new BlockCoord(slaves.func_150306_c(i)));
            }
        }
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74768_a("display", this.digit);
        tag.func_74757_a("isSlave", this.isSlave);
        tag.func_74768_a("color", this.color);
        tag.func_74768_a("mode", this.mode);
        if (this.isSlave) {
            tag.func_74783_a("parent", this.parent.intArray());
        } else {
            NBTTagList slaves = new NBTTagList();
            for (BlockCoord slave : this.slaves) {
                slaves.func_74742_a((NBTBase)new NBTTagIntArray(slave.intArray()));
            }
            tag.func_74782_a("slaves", (NBTBase)slaves);
        }
    }

    @Override
    public void readDesc(NBTTagCompound compound) {
        this.digit = compound.func_74762_e("digit");
        this.color = compound.func_74762_e("color");
        this.isSlave = compound.func_74767_n("isSlave");
        this.hasSlaves = compound.func_74767_n("hasSlaves");
        this.mode = compound.func_74762_e("mode");
    }

    @Override
    public void writeDesc(NBTTagCompound compound) {
        compound.func_74768_a("digit", this.digit);
        compound.func_74768_a("color", this.color);
        compound.func_74757_a("isSlave", this.isSlave);
        compound.func_74757_a("hasSlaves", this.slaves.size() > 0);
        compound.func_74768_a("mode", this.mode);
    }

    @Override
    public void read(byte discr, MCDataInput packet) {
        if (discr == 10) {
            this.digit = packet.readInt();
        } else if (discr == 11) {
            this.isSlave = packet.readBoolean();
            this.hasSlaves = packet.readBoolean();
            this.provider.markRender();
        } else {
            super.read(discr, packet);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack(Content.item7Segment, 1, this.color);
    }

    @Override
    public ISocket.EnumConnectionType getConnectionTypeAtSide(int side) {
        return this.isSlave || this.hasSlaves && side == 1 ? ISocket.EnumConnectionType.NONE : (this.mode == 0 ? ISocket.EnumConnectionType.SIMPLE : (this.mode == 1 ? ISocket.EnumConnectionType.ANALOG : ISocket.EnumConnectionType.BUNDLED));
    }

    @Override
    public Cuboid6 getDimension() {
        return this.dimensions;
    }
}

