/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate;

import codechicken.lib.vec.Cuboid6;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.api.gate.IGatePeripheralProvider;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.gate.Gate;
import moe.nightfall.vic.integratedcircuits.gate.peripheral.CircuitPeripheral;
import moe.nightfall.vic.integratedcircuits.gate.peripheral.GatePeripheral;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GateCircuit
extends Gate
implements ICircuit,
IGatePeripheralProvider {
    public static final Cuboid6 dimensions = new Cuboid6(2.0, 0.0, 2.0, 14.0, 2.0, 14.0);
    public CircuitData circuitData;
    private boolean update;
    private CircuitPeripheral peripheral = new CircuitPeripheral(this);

    @Override
    public void preparePlacement(EntityPlayer player, ItemStack stack) {
        NBTTagCompound comp = stack.field_77990_d;
        if (comp == null) {
            return;
        }
        this.circuitData = CircuitData.readFromNBT(comp.func_74775_l("circuit"), this);
        this.circuitData.setQueueEnabled(false);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.circuitData = CircuitData.readFromNBT(tag.func_74775_l("circuit"), this);
        this.circuitData.setQueueEnabled(false);
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74782_a("circuit", (NBTBase)this.circuitData.writeToNBTRaw(new NBTTagCompound()));
    }

    @Override
    public void readDesc(NBTTagCompound compound) {
        this.circuitData = CircuitData.readFromNBT(compound.func_74775_l("circuit_data"), this);
        this.circuitData.setQueueEnabled(false);
    }

    @Override
    public void writeDesc(NBTTagCompound compound) {
        compound.func_74782_a("circuit_data", (NBTBase)this.circuitData.writeToNBTRaw(new NBTTagCompound()));
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack(Content.itemCircuit);
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74782_a("circuit", (NBTBase)this.getCircuitData().writeToNBTRaw(new NBTTagCompound()));
        stack.field_77990_d = comp;
        return stack;
    }

    @Override
    public CircuitData getCircuitData() {
        return this.circuitData;
    }

    @Override
    public void onAdded() {
        if (!this.provider.getWorld().field_72995_K) {
            this.provider.updateInput();
            this.circuitData.updateInput();
            this.circuitData.updateOutput();
        }
    }

    @Override
    public void updateInputPost() {
        super.updateInputPost();
        this.provider.scheduleTick(0);
    }

    @Override
    public void scheduledTick() {
        this.circuitData.updateInput();
    }

    @Override
    public void update() {
        if (!this.provider.getWorld().field_72995_K) {
            this.circuitData.updateMatrix();
        }
    }

    @Override
    public void setCircuitData(CircuitData data) {
        this.circuitData = data;
    }

    @Override
    public boolean getInputFromSide(ForgeDirection dir, int frequency) {
        int side = (MiscUtils.getSide(dir) + 2) % 4;
        if (this.getConnectionTypeAtSide(side) == ISocket.EnumConnectionType.ANALOG) {
            return this.provider.getRedstoneInput(side) == frequency;
        }
        return this.provider.getBundledInput(side, frequency) != 0;
    }

    @Override
    public void setOutputToSide(ForgeDirection dir, int frequency, boolean output) {
        int side = (MiscUtils.getSide(dir) + 2) % 4;
        ISocket.EnumConnectionType mode = this.getConnectionTypeAtSide(side);
        if (mode == ISocket.EnumConnectionType.SIMPLE && frequency > 0) {
            return;
        }
        this.provider.setOutput(side, frequency, (byte)(output ? (mode == ISocket.EnumConnectionType.BUNDLED ? -1 : 15) : 0));
        this.provider.notifyBlocksAndChanges();
    }

    @Override
    public boolean hasPeripheral(int side) {
        return true;
    }

    @Override
    public GatePeripheral getPeripheral() {
        return this.peripheral;
    }

    @Override
    public ISocket.EnumConnectionType getConnectionTypeAtSide(int side) {
        return this.circuitData.getProperties().getModeAtSide((side + 2) % 4);
    }

    @Override
    public boolean hasComparatorInputAtSide(int side) {
        return this.getConnectionTypeAtSide(side) == ISocket.EnumConnectionType.ANALOG;
    }

    @Override
    public Cuboid6 getDimension() {
        return dimensions;
    }
}

