/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.IPartRenderer;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.GateIOProvider;
import moe.nightfall.vic.integratedcircuits.api.gate.IGate;
import moe.nightfall.vic.integratedcircuits.api.gate.IGateRegistry;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketWrapper;
import moe.nightfall.vic.integratedcircuits.client.SocketRenderer;
import moe.nightfall.vic.integratedcircuits.gate.Socket;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import moe.nightfall.vic.integratedcircuits.tile.FMPartSocket;
import moe.nightfall.vic.integratedcircuits.tile.TileEntitySocket;
import net.minecraft.block.Block;

public class GateRegistry
implements IGateRegistry {
    private boolean lock = false;
    private BiMap<String, Class<? extends IGate>> registry = HashBiMap.create();
    private Map<IntegratedCircuitsAPI.Type, Set<GateIOProvider>> ioProviderRegistry = Maps.newHashMap();
    private Map<IntegratedCircuitsAPI.Type, Set<Class<?>>> interfaceMap;
    private Map<Class<?>, GateIOProvider> ioProviderMap;

    public GateIOProvider getProvider(Class<?> intf) {
        return this.ioProviderMap.get(intf);
    }

    public void lock() {
        if (!this.lock) {
            IntegratedCircuits.logger.info("Locking IO provider registry and building caches");
            this.ioProviderMap = Maps.newHashMap();
            this.interfaceMap = Maps.newEnumMap(IntegratedCircuitsAPI.Type.class);
            for (IntegratedCircuitsAPI.Type type : this.ioProviderRegistry.keySet()) {
                Set<GateIOProvider> ioProviderSet = this.ioProviderRegistry.get((Object)type);
                for (GateIOProvider provider : ioProviderSet) {
                    Optional.InterfaceList intfList;
                    Optional.Interface intf = provider.getClass().getAnnotation(Optional.Interface.class);
                    if (intf != null) {
                        this.addInterface(intf, provider, type);
                    }
                    if ((intfList = provider.getClass().getAnnotation(Optional.InterfaceList.class)) == null) continue;
                    for (Optional.Interface intf2 : intfList.value()) {
                        this.addInterface(intf2, provider, type);
                    }
                }
            }
        }
        this.lock = true;
    }

    private void addInterface(Optional.Interface intf, GateIOProvider provider, IntegratedCircuitsAPI.Type type) {
        if (Loader.isModLoaded((String)intf.modid())) {
            try {
                Class<?> intfClazz = Class.forName(intf.iface());
                this.ioProviderMap.put(intfClazz, provider);
                HashSet set = this.interfaceMap.get((Object)type);
                set = set == null ? new HashSet() : set;
                set.add(intfClazz);
                this.interfaceMap.put(type, set);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid interface specified on io provider " + provider.getClass() + " : " + intf.iface());
            }
        }
    }

    @Override
    public void registerGate(String name, Class<? extends IGate> clazz) {
        this.registry.put((Object)name, clazz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <T extends IGate> void registerGateRenderer(Class<T> clazz, IPartRenderer<T> renderer) {
        ClientProxy.rendererRegistry.put(clazz, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPartRenderer<IGate> getRenderer(Class<? extends IGate> clazz) {
        return ClientProxy.rendererRegistry.get(clazz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPartRenderer<IGate> getRenderer(String gateID) {
        return this.getRenderer((Class)this.registry.get((Object)gateID));
    }

    @Override
    public String getName(Class<? extends IGate> gate) {
        return (String)this.registry.inverse().get(gate);
    }

    @Override
    public IGate createGateInstace(String name) {
        try {
            return (IGate)((Class)this.registry.get((Object)name)).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Coundn't instance gate \"" + name + "\", need an empty constructor!");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPartRenderer<ISocket> createDefaultSocketRenderer(String iconName) {
        ClientProxy.icons.add(iconName);
        return new SocketRenderer(iconName);
    }

    @Override
    public void registerGateIOProvider(GateIOProvider provider, IntegratedCircuitsAPI.Type ... elements) {
        for (IntegratedCircuitsAPI.Type element : elements) {
            this.registerGateIOProvider(provider, element);
        }
    }

    private void registerGateIOProvider(GateIOProvider provider, IntegratedCircuitsAPI.Type element) {
        if (this.lock) {
            IntegratedCircuits.logger.fatal("Tried to register gate provider instance after initialization phase: " + Loader.instance().activeModContainer());
            return;
        }
        HashSet set = this.ioProviderRegistry.get((Object)element);
        if (set == null) {
            set = Sets.newHashSet();
        }
        set.add(provider);
        this.ioProviderRegistry.put(element, set);
    }

    public Set<GateIOProvider> getIOProviderList(IntegratedCircuitsAPI.Type type) {
        return this.ioProviderRegistry.get((Object)type);
    }

    public Set<GateIOProvider> getIOProviderList(Class<?> clazz) {
        if (clazz == TileEntitySocket.class) {
            return this.ioProviderRegistry.get((Object)IntegratedCircuitsAPI.Type.TILE);
        }
        if (clazz == Block.class) {
            return this.ioProviderRegistry.get((Object)IntegratedCircuitsAPI.Type.BLOCK);
        }
        if (IntegratedCircuits.isFMPLoaded && clazz == FMPartSocket.class) {
            return this.ioProviderRegistry.get((Object)IntegratedCircuitsAPI.Type.TILE_FMP);
        }
        return null;
    }

    public Set<Class<?>> getInterfaceMapping(IntegratedCircuitsAPI.Type type) {
        HashSet set = this.interfaceMap.get((Object)type);
        return set != null ? set : new HashSet();
    }

    @Override
    public ISocket createSocketInstance(ISocketWrapper wrapper) {
        return new Socket(wrapper);
    }
}

