/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.bluepowermod.api.misc.IScrewdriver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.IGate;
import moe.nightfall.vic.integratedcircuits.api.gate.IGateItem;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketWrapper;
import moe.nightfall.vic.integratedcircuits.misc.InventoryUtils;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class Socket
implements ISocket {
    public static Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected final ISocketWrapper provider;
    protected final Map<String, Object> extendedProperties;
    protected IGate gate;
    protected byte io;
    protected byte[][] output = new byte[4][16];
    protected byte[][] input = new byte[4][16];
    protected byte orientation;

    public Socket(ISocketWrapper provider) {
        this.provider = provider;
        this.extendedProperties = new HashMap<String, Object>();
    }

    @Override
    public void update() {
        if (this.gate != null) {
            this.gate.update();
        }
    }

    @Override
    public void onAdded() {
        if (this.gate != null) {
            this.gate.onAdded();
        }
    }

    @Override
    public void onMoved() {
        if (this.gate != null) {
            this.gate.onMoved();
        }
    }

    @Override
    public void scheduledTick() {
        if (this.gate != null) {
            this.gate.scheduledTick();
        }
    }

    @Override
    public void onRemoved() {
        if (this.gate != null) {
            this.gate.onRemoved();
        }
    }

    @Override
    public void markRender() {
        this.provider.markRender();
    }

    @Override
    public MCDataOutput getWriteStream(int disc) {
        return this.provider.getWriteStream(disc);
    }

    @Override
    public World getWorld() {
        return this.provider.getWorld();
    }

    @Override
    public void notifyBlocksAndChanges() {
        this.notifyPartChange();
        this.provider.notifyBlocksAndChanges();
    }

    @Override
    public void notifyPartChange() {
        if (!this.provider.getWorld().field_72995_K) {
            this.updateRedstoneIO();
        }
        this.provider.notifyPartChange();
    }

    @Override
    public BlockCoord getPos() {
        return this.provider.getPos();
    }

    @Override
    public void sendDescription() {
        this.provider.sendDescription();
    }

    @Override
    public void destroy() {
        if (this.gate != null) {
            BlockCoord pos = this.getPos();
            MiscUtils.dropItem(this.getWorld(), this.gate.getItemStack(), pos.x, pos.y, pos.z);
        }
        this.provider.destroy();
    }

    @Override
    public int updateRedstoneInput(int side) {
        return this.provider.updateRedstoneInput(side);
    }

    @Override
    public byte[] updateBundledInput(int side) {
        return this.provider.updateBundledInput(side);
    }

    @Override
    public void scheduleTick(int delay) {
        this.provider.scheduleTick(delay);
    }

    @Override
    public void setGate(IGate gate) {
        this.gate = gate;
        this.gate.setProvider(this);
        this.gate.onAdded();
    }

    @Override
    public IGate getGate() {
        return this.gate;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.orientation = compound.func_74771_c("orientation");
        this.io = compound.func_74771_c("io");
        byte[] input = compound.func_74770_j("input");
        byte[] output = compound.func_74770_j("output");
        for (int i = 0; i < 4; ++i) {
            this.input[i] = Arrays.copyOfRange(input, i * 16, (i + 1) * 16);
            this.output[i] = Arrays.copyOfRange(output, i * 16, (i + 1) * 16);
        }
        if (compound.func_74764_b("gate_id")) {
            this.gate = IntegratedCircuitsAPI.getGateRegistry().createGateInstace(compound.func_74779_i("gate_id"));
            this.gate.setProvider(this);
            this.gate.load(compound.func_74775_l("gate"));
        } else {
            this.gate = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("orientation", this.orientation);
        compound.func_74774_a("io", this.io);
        byte[] input = null;
        byte[] output = null;
        for (int i = 0; i < 4; ++i) {
            input = ArrayUtils.addAll(input, (byte[])this.input[i]);
            output = ArrayUtils.addAll(output, (byte[])this.output[i]);
        }
        compound.func_74773_a("input", input);
        compound.func_74773_a("output", output);
        if (this.gate != null) {
            compound.func_74778_a("gate_id", IntegratedCircuitsAPI.getGateRegistry().getName(this.gate.getClass()));
            NBTTagCompound gateCompound = new NBTTagCompound();
            this.gate.save(gateCompound);
            compound.func_74782_a("gate", (NBTBase)gateCompound);
        }
    }

    @Override
    public void writeDesc(NBTTagCompound compound) {
        compound.func_74774_a("orientation", this.orientation);
        compound.func_74774_a("io", this.io);
        if (this.gate != null) {
            compound.func_74778_a("gate_id", IntegratedCircuitsAPI.getGateRegistry().getName(this.gate.getClass()));
            this.gate.writeDesc(compound);
        }
    }

    @Override
    public void readDesc(NBTTagCompound compound) {
        this.orientation = compound.func_74771_c("orientation");
        this.io = compound.func_74771_c("io");
        if (compound.func_74764_b("gate_id")) {
            this.gate = IntegratedCircuitsAPI.getGateRegistry().createGateInstace(compound.func_74779_i("gate_id"));
            this.gate.setProvider(this);
            this.gate.readDesc(compound);
        } else {
            this.gate = null;
        }
        this.markRender();
    }

    @Override
    public void read(MCDataInput packet) {
        byte discr = packet.readByte();
        switch (discr) {
            case 0: {
                this.orientation = packet.readByte();
                this.markRender();
                return;
            }
            case 1: {
                this.io = packet.readByte();
                this.markRender();
                return;
            }
        }
        if (this.gate != null) {
            this.gate.read(discr, packet);
        }
    }

    @Override
    public byte getOrientation() {
        return this.orientation;
    }

    @Override
    public int getSide() {
        return this.orientation >> 2;
    }

    @Override
    public int getSideRel(int side) {
        return this.getRotationRel(Rotation.rotationTo((int)this.getSide(), (int)side));
    }

    @Override
    public void setSide(int s) {
        this.orientation = (byte)(this.orientation & 3 | s << 2);
    }

    @Override
    public int getRotation() {
        return this.orientation & 3;
    }

    @Override
    public int getRotationAbs(int rel) {
        return (rel + this.getRotation() + 2) % 4;
    }

    @Override
    public int getRotationRel(int abs) {
        return (abs + 6 - this.getRotation()) % 4;
    }

    @Override
    public void setRotation(int r) {
        this.orientation = (byte)(this.orientation & 0xFC | r);
    }

    @Override
    public byte[][] getInput() {
        return this.input;
    }

    @Override
    public byte[][] getOutput() {
        return this.output;
    }

    @Override
    public byte getRedstoneInput(int side) {
        return this.getBundledInput(side, 0);
    }

    @Override
    public byte getBundledInput(int side, int frequency) {
        byte i = this.input[side][frequency];
        if (this.getConnectionTypeAtSide(side) == ISocket.EnumConnectionType.ANALOG ? i <= this.getRedstoneOutput(side) : this.output[side][frequency] != 0) {
            return 0;
        }
        return i;
    }

    @Override
    public byte getRedstoneOutput(int side) {
        ISocket.EnumConnectionType conType = this.getConnectionTypeAtSide(side);
        if (conType == ISocket.EnumConnectionType.ANALOG) {
            byte[] out = this.getOutput()[side];
            for (byte i = 15; i >= 0; i = (byte)(i - 1)) {
                if (out[i] == 0) continue;
                return i;
            }
            return 0;
        }
        if (conType == ISocket.EnumConnectionType.SIMPLE) {
            return this.getBundledOutput(side, 0);
        }
        return 0;
    }

    @Override
    public byte getBundledOutput(int side, int frequency) {
        return this.output[side][frequency];
    }

    @Override
    public void setInput(byte[][] input) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input;
    }

    @Override
    public void setOutput(byte[][] output) {
        if (output == null) {
            throw new NullPointerException();
        }
        this.output = output;
    }

    @Override
    public void setInput(int side, int frequency, byte input) {
        this.input[side][frequency] = input;
    }

    @Override
    public void setOutput(int side, int frequency, byte output) {
        this.output[side][frequency] = output;
    }

    @Override
    public void resetInput() {
        this.input = new byte[4][16];
    }

    @Override
    public void resetOutput() {
        this.output = new byte[4][16];
    }

    @Override
    public void updateInput() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.updateInputPre();
        for (int i = 0; i < 4; ++i) {
            ISocket.EnumConnectionType type = this.getConnectionTypeAtSide(i);
            if (type.isRedstone()) {
                this.input[i][0] = (byte)this.updateRedstoneInput(i);
                continue;
            }
            if (!type.isBundled()) continue;
            this.input[i] = this.updateBundledInput(i);
        }
        this.updateInputPost();
    }

    @Override
    public void updateInputPre() {
        if (this.gate != null) {
            this.gate.updateInputPre();
        }
    }

    @Override
    public void updateInputPost() {
        if (this.gate != null) {
            this.gate.updateInputPost();
            this.updateRedstoneIO();
        }
    }

    @Override
    public ISocket.EnumConnectionType getConnectionTypeAtSide(int side) {
        return this.gate != null ? this.gate.getConnectionTypeAtSide(side) : ISocket.EnumConnectionType.NONE;
    }

    private void updateRedstoneIO() {
        byte oio = this.io;
        this.io = 0;
        for (int i = 0; i < 4; ++i) {
            this.io = (byte)(this.io | (this.getRedstoneInput(i) != 0 || this.getRedstoneOutput(i) != 0 ? 1 << i : 0));
        }
        if (oio != this.io) {
            this.provider.getWriteStream(1).writeByte((int)this.io);
        }
    }

    @Override
    public void preparePlacement(EntityPlayer player, BlockCoord pos, int side, ItemStack stack) {
        this.setSide(side ^ 1);
        this.setRotation(Rotation.getSidedRotation((EntityPlayer)player, (int)side));
    }

    @Override
    public void setGate(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b() instanceof IGateItem) {
            String gateID = ((IGateItem)stack.func_77973_b()).getGateID(stack, player, this.getPos());
            this.gate = IntegratedCircuitsAPI.getGateRegistry().createGateInstace(gateID);
            this.gate.setProvider(this);
            this.gate.preparePlacement(player, stack);
            this.gate.onAdded();
            this.sendDescription();
            this.notifyBlocksAndChanges();
        }
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack stack) {
        if (stack != null) {
            if (!this.getWorld().field_72995_K) {
                if (this.gate == null && stack.func_77973_b() instanceof IGateItem) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack solderingIron = InventoryUtils.getFirstItem(Content.itemSolderingIron, (IInventory)player.field_71071_by);
                        if (solderingIron != null) {
                            solderingIron.func_77972_a(1, (EntityLivingBase)player);
                            if (solderingIron.func_77960_j() == solderingIron.func_77958_k()) {
                                player.field_71071_by.func_70299_a(InventoryUtils.getSlotIndex(solderingIron, (IInventory)player.field_71071_by), null);
                            }
                            player.field_71069_bz.func_75142_b();
                        } else {
                            return false;
                        }
                    }
                    int rotation = Rotation.getSidedRotation((EntityPlayer)player, (int)(this.getSide() ^ 1));
                    this.setRotation(rotation);
                    this.setGate(stack, player);
                    if (!player.field_71075_bZ.field_75098_d && ((IGateItem)stack.func_77973_b()).usedUpOnPlace(player).booleanValue() && this.usesUpPlacedGate()) {
                        --stack.field_77994_a;
                    }
                    MiscUtils.playPlaceSound(this.getWorld(), this.getPos());
                    return true;
                }
                if (this.gate != null && stack.func_77973_b() == Content.itemSolderingIron) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (stack.func_77960_j() == stack.func_77958_k()) {
                        --stack.field_77994_a;
                    } else {
                        ((EntityPlayerMP)player).func_71113_k();
                    }
                    if (!player.field_71075_bZ.field_75098_d && ((IGateItem)this.gate.getItemStack().func_77973_b()).usedUpOnPlace(player).booleanValue() && this.usesUpPlacedGate()) {
                        BlockCoord pos = this.getPos();
                        MiscUtils.dropItem(this.getWorld(), this.gate.getItemStack(), pos.x, pos.y, pos.z);
                    }
                    this.gate = null;
                    this.sendDescription();
                    this.notifyBlocksAndChanges();
                    return true;
                }
            }
            Item item = stack.func_77973_b();
            String name = item.func_77658_a();
            if (Socket.checkItemIsTool(item)) {
                if (!this.getWorld().field_72995_K && this.gate != null) {
                    if (!player.func_70093_af()) {
                        this.rotate();
                    }
                    this.gate.onActivatedWithScrewdriver(player, hit, stack);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        if (this.gate != null) {
            return this.gate.activate(player, hit, stack);
        }
        return false;
    }

    public static boolean checkItemIsTool(Item item) {
        if (item != null) {
            return IntegratedCircuits.isPRLoaded && item instanceof mrtjp.projectred.api.IScrewdriver || item == Content.itemScrewdriver || item.func_77658_a().equals("item.redlogic.screwdriver") || IntegratedCircuits.isBPAPIThere && item instanceof IScrewdriver || IntegratedCircuits.isBCToolsAPIThere && item instanceof IToolWrench;
        }
        return false;
    }

    @Override
    public boolean rotate() {
        this.setRotation((this.getRotation() + 1) % 4);
        if (!this.getWorld().field_72995_K) {
            this.getWriteStream(0).writeByte((int)this.orientation);
        }
        this.notifyBlocksAndChanges();
        if (this.gate != null && !this.getWorld().field_72995_K) {
            this.gate.onRotated();
            this.updateInput();
        }
        return true;
    }

    @Override
    public void onNeighborChanged() {
        if (!this.getWorld().field_72995_K) {
            BlockCoord pos = this.getPos().offset(this.getSide());
            if (!MiscUtils.canPlaceGateOnSide(this.getWorld(), pos.x, pos.y, pos.z, this.getSide() ^ 1)) {
                this.destroy();
            } else {
                this.updateInput();
            }
        }
        if (this.gate != null) {
            this.gate.onNeighborChanged();
        }
    }

    @Override
    public void addDrops(List<ItemStack> list) {
        if (this.gate != null) {
            list.add(this.gate.getItemStack());
        }
    }

    @Override
    public boolean usesUpPlacedGate() {
        return true;
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition mop) {
        if (this.gate != null) {
            return this.gate.pickItem(mop);
        }
        return null;
    }

    public static Transformation getRotationTransformation(ISocket socket) {
        return Rotation.sideOrientation((int)socket.getSide(), (int)socket.getRotation()).at(Vector3.center);
    }

    @Override
    public ISocketWrapper getWrapper() {
        return this.provider;
    }

    @Override
    public <T> T get(String key) {
        return (T)this.extendedProperties.get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.extendedProperties.put(key, value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public byte getRedstoneIO() {
        return this.io;
    }
}

