/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate.peripheral;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Map;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.gate.GateCircuit;
import moe.nightfall.vic.integratedcircuits.gate.peripheral.FileMount;
import moe.nightfall.vic.integratedcircuits.gate.peripheral.GatePeripheral;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class CircuitPeripheral
extends GatePeripheral {
    private GateCircuit circuit;

    public CircuitPeripheral(GateCircuit circuit) {
        this.circuit = circuit;
    }

    @Override
    public String getType() {
        return "ic_circuit";
    }

    @GatePeripheral.LuaMethod
    public Object[] getGateAt(double x, double y) {
        CircuitData cdata = this.circuit.getCircuitData();
        Vec2 pos = this.getPos(x, y);
        CircuitPart cp = cdata.getPart(pos);
        String name = cp.getName(pos, this.circuit);
        int id = CircuitPart.getId(cp);
        int meta = cp.getState(pos, this.circuit);
        return new Object[]{name, id, meta};
    }

    @GatePeripheral.LuaMethod
    public Object[] getPowerTo(double x, double y) {
        CircuitData cdata = this.circuit.getCircuitData();
        Vec2 pos = this.getPos(x, y);
        CircuitPart cp = cdata.getPart(pos);
        boolean b1 = cp.getInputFromSide(pos, this.circuit, ForgeDirection.NORTH);
        boolean b2 = cp.getInputFromSide(pos, this.circuit, ForgeDirection.EAST);
        boolean b3 = cp.getInputFromSide(pos, this.circuit, ForgeDirection.SOUTH);
        boolean b4 = cp.getInputFromSide(pos, this.circuit, ForgeDirection.WEST);
        return new Boolean[]{b1, b2, b3, b4};
    }

    @GatePeripheral.LuaMethod
    public Object[] getGateProperties(double x, double y) {
        CircuitData cdata = this.circuit.getCircuitData();
        CircuitPart cp = cdata.getPart(this.getPos(x, y));
        Map<String, PropertyStitcher.IProperty> properties = cp.stitcher.getProperties();
        return properties.keySet().toArray();
    }

    @GatePeripheral.LuaMethod
    public Object[] getGateProperty(double x, double y, String name) throws GatePeripheral.LuaException {
        CircuitData cdata = this.circuit.getCircuitData();
        Vec2 pos = this.getPos(x, y);
        CircuitPart cp = cdata.getPart(pos);
        int state = cp.getState(pos, this.circuit);
        PropertyStitcher.IProperty property = this.getProperty(cp, pos, name);
        return new Object[]{property.get(state), property.getClass().getSimpleName()};
    }

    @GatePeripheral.LuaMethod
    public void setGateProperty(double x, double y, String name, Object obj) throws GatePeripheral.LuaException {
        CircuitData cdata = this.circuit.getCircuitData();
        Vec2 pos = this.getPos(x, y);
        CircuitPart cp = cdata.getPart(pos);
        int state = cp.getState(pos, this.circuit);
        PropertyStitcher.IProperty property = this.getProperty(cp, pos, name);
        if (!Config.enablePropertyEdit) {
            throw new GatePeripheral.LuaException("Property editing is disabled from the config file.");
        }
        if (obj instanceof Double) {
            obj = ((Double)obj).intValue();
        }
        cp.setProperty(pos, this.circuit, property, (Comparable)obj);
        cp.notifyNeighbours(pos, this.circuit);
    }

    @GatePeripheral.LuaMethod
    public Object[] getOutputToSide(double side) throws GatePeripheral.LuaException {
        if (side < 0.0 || side > 3.0) {
            throw new GatePeripheral.LuaException(String.format("Illegal side provided. (%s) [0->3]", side));
        }
        return ArrayUtils.toObject((byte[])this.circuit.getProvider().getOutput()[(int)side]);
    }

    @GatePeripheral.LuaMethod
    public Object[] getInputFromSide(double side) throws GatePeripheral.LuaException {
        if (side < 0.0 || side > 3.0) {
            throw new GatePeripheral.LuaException(String.format("Illegal side provided. (%s) [0->3]", side));
        }
        return ArrayUtils.toObject((byte[])this.circuit.getProvider().getInput()[(int)side]);
    }

    @GatePeripheral.LuaMethod
    public double getSize() {
        return this.circuit.getCircuitData().getSize();
    }

    @GatePeripheral.LuaMethod
    public String getName() {
        return this.circuit.getCircuitData().getProperties().getName();
    }

    @GatePeripheral.LuaMethod
    public String getAuthor() {
        return this.circuit.getCircuitData().getProperties().getAuthor();
    }

    @GatePeripheral.LuaMethod
    public String getGateName(double id) {
        CircuitPart cp = CircuitPart.getPart((int)id);
        return cp.toString();
    }

    private Vec2 getPos(double x, double y) {
        return new Vec2((int)x, (int)y);
    }

    private PropertyStitcher.IProperty getProperty(CircuitPart part, Vec2 pos, String name) throws GatePeripheral.LuaException {
        PropertyStitcher.IProperty property = part.stitcher.getPropertyByName(name);
        if (property == null) {
            throw new GatePeripheral.LuaException(String.format("No property by the name of '&s' found for gate %s", name, part.getName(pos, this.circuit)));
        }
        return property;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        computer.mount("rom/programs/integratedcircuits", (IMount)new FileMount("lua"));
    }
}

