/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.gate.peripheral;

import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Map;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public abstract class GatePeripheral
implements IPeripheral {
    private final Map<String, Method> methods = Maps.newLinkedHashMap();
    private final String[] methodNames;

    public abstract String getType();

    public GatePeripheral() {
        for (Method m : this.getClass().getMethods()) {
            if (m.getAnnotation(LuaMethod.class) == null) continue;
            this.methods.put(m.getName(), m);
        }
        this.methodNames = this.methods.keySet().toArray(new String[this.methods.size()]);
    }

    public final String[] getMethodNames() {
        return this.methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public final Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws dan200.computercraft.api.lua.LuaException, InterruptedException {
        String name = (String)this.methods.keySet().toArray()[method];
        try {
            return this.callMethod(name, arguments);
        }
        catch (Exception e) {
            throw new dan200.computercraft.api.lua.LuaException(e.getMessage());
        }
    }

    public final Object[] callMethod(String name, Object[] arguments) throws Exception {
        Method m = this.methods.get(name);
        if (m == null) {
            return null;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (arguments.length != paramTypes.length) {
            throw new LuaException("Illegal amount of parameters!");
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = Primitives.wrap(paramTypes[i]);
            if (paramTypes[i].isAssignableFrom(arguments[i].getClass())) continue;
            throw new LuaException("Illegal parameter at index " + i + ". Expected '" + paramTypes[i] + "', got '" + arguments[i].getClass() + "'.");
        }
        Object o = m.invoke((Object)this, arguments);
        if (o == null) {
            return null;
        }
        if (m.getReturnType().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other.getType().equals(this.getType());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface LuaMethod {
    }

    public static class LuaException
    extends RuntimeException {
        public LuaException(String message) {
            super(message);
        }
    }
}

