/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.item;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TItemMultiPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.Optional;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketWrapper;
import moe.nightfall.vic.integratedcircuits.item.ItemBase;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Optional.Interface(iface="codechicken.multipart.TItemMultiPart", modid="ForgeMultipart")
public class ItemSocketFMP
extends ItemBase
implements TItemMultiPart {
    public ItemSocketFMP() {
        super("socket_fmp");
        this.setHasIcon(false);
    }

    public double getHitDepth(Vector3 vhit, int side) {
        return vhit.copy().scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockCoord pos = new BlockCoord(x, y, z);
        Vector3 vhit = new Vector3((double)hitX, (double)hitY, (double)hitZ);
        double d = this.getHitDepth(vhit, side);
        if (d < 1.0 && this.place(stack, player, world, pos, side, vhit)) {
            return true;
        }
        pos.offset(side);
        return this.place(stack, player, world, pos, side, vhit);
    }

    private boolean place(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 vhit) {
        BlockCoord pos2 = pos.copy().offset(side ^ 1);
        if (!MiscUtils.canPlaceGateOnSide(world, pos2.x, pos2.y, pos2.z, side)) {
            return false;
        }
        if (!this.placeFMP(stack, player, world, pos, side, vhit)) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        return true;
    }

    @Optional.Method(modid="ForgeMultipart")
    private boolean placeFMP(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 vhit) {
        TMultiPart part = this.newPart(stack, player, world, pos, side, vhit);
        if (!TileMultipart.canPlacePart((World)world, (BlockCoord)pos, (TMultiPart)part)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
        }
        return true;
    }

    public TMultiPart newPart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5) {
        ISocketWrapper part = (ISocketWrapper)MultiPartRegistry.createPart((String)"integratedcircuits.socket_fmp", (boolean)false);
        part.getSocket().preparePlacement(player, pos, side, stack);
        return (TMultiPart)part;
    }
}

