/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.InventoryUtils;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingSupply {
    private CraftingAmount cache = new CraftingAmount();
    private TileEntityContainer provider;
    private int from;
    private int to;
    private ItemAmount insufficient;

    public CraftingSupply(TileEntityContainer provider, int from, int to) {
        this.provider = provider;
        this.from = from;
        this.to = to;
    }

    public void clear() {
        this.cache.getCraftingAmount().clear();
    }

    public boolean request(CraftingAmount amount) {
        if (this.insufficient != null && !amount.contains(this.insufficient)) {
            return false;
        }
        this.insufficient = null;
        for (ItemAmount ia : amount.getCraftingAmount()) {
            if (this.isSupplied(ia)) continue;
            return false;
        }
        for (ItemAmount ia : amount.getCraftingAmount()) {
            this.consume(ia);
        }
        return true;
    }

    public void consume(ItemAmount amount) {
        ItemAmount cached = this.cache.get(amount);
        cached.amount -= amount.amount;
    }

    public boolean isSupplied(ItemAmount amount) {
        ItemAmount cached = null;
        if (this.cache.contains(amount)) {
            cached = this.cache.get(amount);
            if (amount.amount <= cached.amount) {
                return true;
            }
        }
        double am = amount.amount;
        if (cached != null) {
            am -= cached.amount;
        }
        int request = (int)Math.ceil(am);
        if (InventoryUtils.tryFetchItem(this.provider, new ItemStack(amount.item), this.from, this.to) != null) {
            this.cache.add(new ItemAmount(amount.item, request));
            return true;
        }
        this.insufficient = amount;
        return false;
    }

    public static CraftingSupply readFromNBT(NBTTagCompound compound, TileEntityContainer provider, int from, int to) {
        CraftingSupply supply = new CraftingSupply(provider, from, to);
        NBTTagList list = compound.func_150295_c("supply", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound comp = list.func_150305_b(i);
            supply.cache.add(ItemAmount.readFromNBT(comp));
        }
        if (compound.func_74764_b("insufficient")) {
            supply.insufficient = ItemAmount.readFromNBT(compound.func_74775_l("insufficient"));
        }
        return supply;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ItemAmount amount : this.cache.getCraftingAmount()) {
            NBTTagCompound comp = new NBTTagCompound();
            list.func_74742_a((NBTBase)amount.writeToNBT(comp));
        }
        compound.func_74782_a("supply", (NBTBase)list);
        if (this.insufficient != null) {
            compound.func_74782_a("insufficient", (NBTBase)this.insufficient.writeToNBT(new NBTTagCompound()));
        }
        return compound;
    }

    public ItemAmount getInsufficient() {
        return this.insufficient;
    }

    public void changeInsufficient(ItemAmount insufficient) {
        this.insufficient = insufficient;
    }
}

