/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import java.util.Arrays;
import moe.nightfall.vic.integratedcircuits.net.PacketChangeSetting;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public interface IOptionsProvider {
    public OptionSet getOptionSet();

    public void onSettingChanged(int var1);

    public static class OptionSet<T extends TileEntity> {
        private int[] options = new int[0];
        private T parent;

        public OptionSet(T parent) {
            this.parent = parent;
        }

        public void changeSettingPayload(int setting, int par) {
            this.resize(setting);
            this.options[setting] = par;
        }

        public void changeSetting(int setting, int par) {
            if (this.parent.func_145831_w().field_72995_K) {
                CommonProxy.networkWrapper.sendToServer(new PacketChangeSetting(((TileEntity)this.parent).field_145851_c, ((TileEntity)this.parent).field_145848_d, ((TileEntity)this.parent).field_145849_e, setting, par));
            } else {
                this.changeSettingPayload(setting, par);
            }
        }

        public void changeSetting(int setting, boolean par) {
            this.changeSetting(setting, par ? 1 : 0);
        }

        private void resize(int setting) {
            if (this.options == null) {
                this.options = new int[setting + 1];
            } else if (this.options != null && setting >= this.options.length) {
                this.options = Arrays.copyOf(this.options, setting + 1);
            }
        }

        public int getInt(int setting) {
            this.resize(setting);
            return this.options[setting];
        }

        public boolean getBoolean(int setting) {
            this.resize(setting);
            return this.options[setting] != 0;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound comp) {
            comp.func_74783_a("options", this.options);
            return comp;
        }

        public static <T extends TileEntity> OptionSet<T> readFromNBT(NBTTagCompound comp, T parent) {
            int[] array = comp.func_74759_k("options");
            OptionSet<T> set = new OptionSet<T>(parent);
            set.options = array;
            return set;
        }
    }
}

