/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemAmount {
    public double amount;
    public int damageValue;
    public Item item;

    public ItemAmount(Item item, double amount) {
        this.item = item;
        this.amount = amount;
    }

    public ItemAmount(Item item, double amount, int damageValue) {
        this(item, amount);
        this.damageValue = damageValue;
    }

    public static ItemAmount readFromNBT(NBTTagCompound compound) {
        Item item = (Item)GameData.getItemRegistry().getRaw(compound.func_74779_i("id"));
        int damage = compound.func_74762_e("damage");
        double amount = compound.func_74769_h("amount");
        return new ItemAmount(item, amount, damage);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("id", GameData.getItemRegistry().func_148750_c((Object)this.item));
        compound.func_74768_a("damage", this.damageValue);
        compound.func_74780_a("amount", this.amount);
        return compound;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.damageValue;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemAmount other = (ItemAmount)obj;
        if (Double.doubleToLongBits(this.amount) != Double.doubleToLongBits(other.amount)) {
            return false;
        }
        if (this.damageValue != other.damageValue) {
            return false;
        }
        if (this.item == null && other.item != null) {
            return false;
        }
        return this.item == other.item;
    }

    public boolean hasEqualItem(ItemAmount other) {
        return this.item == other.item && this.damageValue == other.damageValue;
    }

    public ItemStack convertToItemStack() {
        return new ItemStack(this.item, (int)Math.abs(this.amount), this.damageValue);
    }

    public ItemStack convertToItemStack(int amount) {
        return new ItemStack(this.item, amount, this.damageValue);
    }
}

