/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import codechicken.lib.vec.BlockCoord;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class MiscUtils {
    private static ForgeDirection[] order = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    private static int[] index = new int[]{-1, -1, 0, 2, 3, 1, -1};
    public static HashBiMap<String, Integer> colors = HashBiMap.create();

    public static int getColor(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            Integer color = (Integer)colors.get((Object)OreDictionary.getOreName((int)id));
            if (color == null) continue;
            return color;
        }
        return -1;
    }

    public static String getLocalizedColor(int color) {
        if (color == 8) {
            return StatCollector.func_74838_a((String)"item.fireworksCharge.silver");
        }
        return StatCollector.func_74838_a((String)("item.fireworksCharge." + WordUtils.uncapitalize((String)((String)colors.inverse().get((Object)color)).substring(3))));
    }

    public static void playPlaceSound(World world, BlockCoord pos) {
        Block.SoundType sound = world.func_147439_a((int)pos.x, (int)pos.y, (int)pos.z).field_149762_H;
        world.func_72908_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, sound.func_150496_b(), (sound.func_150497_c() + 1.0f) / 2.0f, sound.func_150494_d() * 0.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer thePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static EntityPlayerMP getPlayerByUUID(UUID uuid) {
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (!uuid.equals(player.func_146103_bH().getId())) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayerMP getPlayerByUsername(String username) {
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (!player.func_70005_c_().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    public static ForgeDirection rotn(ForgeDirection fd, int offset) {
        int pos = index[fd.ordinal()];
        int newPos = pos + offset;
        pos = newPos > 3 ? newPos - 4 : (newPos < 0 ? newPos + 4 : newPos);
        return order[pos];
    }

    public static ForgeDirection rot(ForgeDirection fd) {
        return MiscUtils.rotn(fd, 1);
    }

    public static ForgeDirection getDirection(int side) {
        return order[side];
    }

    public static int getSide(ForgeDirection dir) {
        return index[dir.ordinal()];
    }

    public static String getLocalizedDirection(ForgeDirection fd) {
        return I18n.func_135052_a((String)("fdirection." + fd.name().toLowerCase() + ".name"), (Object[])new Object[0]);
    }

    public static AxisAlignedBB getRotatedInstance(AxisAlignedBB def, int rotation) {
        def = def.func_72329_c();
        def.func_72317_d(-0.5, -0.5, -0.5);
        switch (rotation) {
            case 2: {
                def = AxisAlignedBB.func_72330_a((double)def.field_72339_c, (double)def.field_72338_b, (double)(-def.field_72336_d), (double)def.field_72334_f, (double)def.field_72337_e, (double)(-def.field_72340_a));
            }
            case 3: {
                def = AxisAlignedBB.func_72330_a((double)(-def.field_72336_d), (double)def.field_72338_b, (double)(-def.field_72334_f), (double)(-def.field_72340_a), (double)def.field_72337_e, (double)(-def.field_72339_c));
            }
            case 1: {
                def = AxisAlignedBB.func_72330_a((double)(-def.field_72334_f), (double)def.field_72338_b, (double)def.field_72340_a, (double)(-def.field_72339_c), (double)def.field_72337_e, (double)def.field_72336_d);
            }
        }
        def.func_72317_d(0.5, 0.5, 0.5);
        return def;
    }

    public static boolean canPlaceGateOnSide(World world, int x, int y, int z, int side) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        return block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    public static void dropItem(World world, ItemStack stack, int x, int y, int z) {
        if (stack == null) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
        world.func_72838_d((Entity)entityItem);
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static float toBinary16Float(int bits) {
        int mant = bits & 0x3FF;
        int exp = bits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((bits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((bits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static String[] stringNewlineSplit(String toSplit) {
        return toSplit.split("\\r\\n|\\n\\r|\\r|\\n");
    }

    public static String stringNormalizeLinefeed(String normalize) {
        return normalize.replaceAll("\\r\\n", "\n");
    }

    public static String[] stringSplitFormat(String toFormat, Object ... toInsert) {
        return MiscUtils.stringNewlineSplit(String.format(toFormat, toInsert));
    }

    public static List<String> splitTranslateToLocalFormatted(String toTranslate, Object ... toInsert) {
        return Arrays.asList(MiscUtils.stringNewlineSplit(StatCollector.func_74837_a((String)toTranslate, (Object[])toInsert)));
    }

    public static List<String> appendToAll(Object toAppend, List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            list.set(i, toAppend + list.get(i));
        }
        return list;
    }

    public static String translate(String unlocalizedName) {
        String localizedName = StatCollector.func_74838_a((String)unlocalizedName);
        if (localizedName.equals(unlocalizedName) && (localizedName = StatCollector.func_150826_b((String)unlocalizedName)).equals(unlocalizedName)) {
            return null;
        }
        return localizedName;
    }

    public static String translateFormatted(String unlocalizedName, Object ... toInsert) {
        String localizedName = StatCollector.func_74837_a((String)unlocalizedName, (Object[])toInsert);
        if (localizedName.equals(unlocalizedName) && (localizedName = StatCollector.func_150826_b((String)unlocalizedName)).equals(unlocalizedName)) {
            return null;
        }
        return localizedName;
    }

    static {
        colors.put((Object)"dyeBlack", (Object)15);
        colors.put((Object)"dyeRed", (Object)14);
        colors.put((Object)"dyeGreen", (Object)13);
        colors.put((Object)"dyeBrown", (Object)12);
        colors.put((Object)"dyeBlue", (Object)11);
        colors.put((Object)"dyePurple", (Object)10);
        colors.put((Object)"dyeCyan", (Object)9);
        colors.put((Object)"dyeLightGray", (Object)8);
        colors.put((Object)"dyeGray", (Object)7);
        colors.put((Object)"dyePink", (Object)6);
        colors.put((Object)"dyeLime", (Object)5);
        colors.put((Object)"dyeYellow", (Object)4);
        colors.put((Object)"dyeLightBlue", (Object)3);
        colors.put((Object)"dyeMagenta", (Object)2);
        colors.put((Object)"dyeOrange", (Object)1);
        colors.put((Object)"dyeWhite", (Object)0);
    }
}

