/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PropertyStitcher {
    private int offset;
    private HashMap<String, IProperty> properties = Maps.newHashMap();

    private int shift(IProperty property, int bits) {
        int shift = this.shift(bits);
        if (this.properties.containsKey(property.getName())) {
            throw new RuntimeException("There is a already a property by the name " + property.getName() + " registered!");
        }
        this.properties.put(property.getName(), property);
        return shift;
    }

    public int shift(int bits) {
        int oldOffset = this.offset;
        if (this.offset + bits > 32) {
            throw new RuntimeException("Exceeded the total number of bits adressable (32)");
        }
        this.offset += bits;
        return oldOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public Map<String, IProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public IProperty getPropertyByName(String name) {
        return this.properties.get(name);
    }

    public static class BooleanProperty
    implements IProperty<Boolean> {
        private final int offset;
        private final String name;

        public BooleanProperty(String name, PropertyStitcher stitcher) {
            this.name = name;
            this.offset = stitcher.shift(this, 1);
        }

        @Override
        public int getFlag() {
            return 1 << this.offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public Boolean get(int data) {
            return (data & this.getFlag()) != 0;
        }

        @Override
        public int set(Boolean value, int data) {
            int flag = this.getFlag();
            return value != false ? data | flag : data & ~flag;
        }

        @Override
        public int invert(int data) {
            return data ^ this.getFlag();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static abstract class ValueProperty<T extends Comparable>
    implements IProperty<T> {
        private final int flag;
        private final int offset;
        private final int max;
        private final String name;

        public ValueProperty(String name, PropertyStitcher stitcher, int max) {
            this.name = name;
            int size = 1;
            if (max > 0) {
                size = 32 - Integer.numberOfLeadingZeros(max);
            }
            this.offset = stitcher.shift(this, size);
            this.flag = (1 << size) - 1 << this.offset;
            this.max = max;
        }

        @Override
        public int getFlag() {
            return this.flag;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.max;
        }

        @Override
        public T get(int data) {
            return (T)Integer.valueOf((data & this.flag) >>> this.offset);
        }

        @Override
        public int set(T value, int data) {
            return data & ~this.flag | (Integer)value << this.offset & this.flag;
        }

        @Override
        public int invert(int data) {
            return data ^ this.flag;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class IntProperty
    extends ValueProperty<Integer> {
        public IntProperty(String name, PropertyStitcher stitcher, int max) {
            super(name, stitcher, max);
        }

        @Override
        public int set(Integer value, int data) {
            if (value > this.getLimit()) {
                throw new IllegalArgumentException("Exceeded maximum value of " + this.getLimit());
            }
            return super.set(value, data);
        }
    }

    public static class EnumProperty<T extends Enum<T>>
    extends ValueProperty {
        private final Class<T> clazz;

        public EnumProperty(String name, PropertyStitcher stitcher, Class<T> base) {
            super(name, stitcher, (byte)EnumProperty.validate(((Enum[])base.getEnumConstants()).length, base));
            this.clazz = base;
        }

        private static int validate(int i, Class clazz) {
            if (clazz.getEnumConstants().length > 127) {
                throw new IllegalArgumentException("The size of enum " + clazz + " exceeded " + 127);
            }
            return i;
        }

        @Override
        public T get(int data) {
            return (T)((Enum[])this.clazz.getEnumConstants())[(Integer)super.get(data)];
        }

        @Override
        public int set(Comparable value, int data) {
            if (this.clazz.isAssignableFrom(value.getClass())) {
                return super.set(((Enum)((Object)value)).ordinal(), data);
            }
            if (value instanceof Number) {
                int i = ((Number)((Object)value)).intValue();
                if (i < 0) {
                    throw new IllegalArgumentException("Got negative index!");
                }
                if (i >= ((Enum[])this.clazz.getEnumConstants()).length) {
                    throw new ArrayIndexOutOfBoundsException("Index " + i + " exceeded the total number of values assigned by " + this.clazz + " (" + ((Enum[])this.clazz.getEnumConstants()).length + ")");
                }
                return super.set(i, data);
            }
            throw new IllegalArgumentException("Can only accept instances of " + this.clazz + " or numeric values");
        }
    }

    public static interface IProperty<T extends Comparable> {
        public String getName();

        public int getFlag();

        public int getOffset();

        public int set(T var1, int var2);

        public int invert(int var1);

        public T get(int var1);
    }
}

