/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class RayTracer {
    public static Vec3[] getPlayerRay(EntityPlayer player, float partialTicks) {
        Vec3 start = RayTracer.getPositionVector(player, partialTicks);
        Vec3 look = player.func_70676_i(partialTicks);
        double reach = RayTracer.getBlockReachDistance(player);
        Vec3 end = start.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        return new Vec3[]{start, end};
    }

    public static Vec3 getPositionVector(EntityPlayer player, float partialTicks) {
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        if (!(player instanceof EntityPlayerMP)) {
            d1 -= (double)player.getDefaultEyeHeight();
        }
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static MovingObjectPosition rayTraceAABB(EntityPlayer player, float partialTicks, AxisAlignedBB ... alignedAABBs) {
        if (alignedAABBs.length == 0) {
            return null;
        }
        MovingObjectPosition nearest = null;
        Vec3[] playerRay = RayTracer.getPlayerRay(player, partialTicks);
        Vec3 start = playerRay[0];
        Vec3 end = playerRay[1];
        for (AxisAlignedBB aabb : alignedAABBs) {
            MovingObjectPosition pos;
            if (aabb == null || (pos = aabb.func_72327_a(start, end)) == null || nearest != null && !(pos.field_72307_f.func_72438_d(start) < nearest.field_72307_f.func_72438_d(start))) continue;
            nearest = pos;
            nearest.hitInfo = aabb;
        }
        return nearest;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, float partialTicks) {
        Vec3[] playerRay = RayTracer.getPlayerRay(player, partialTicks);
        Vec3 start = playerRay[0];
        Vec3 end = playerRay[1];
        MovingObjectPosition target = player.field_70170_p.func_72933_a(start, end);
        return target;
    }
}

