/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.misc;

import codechicken.lib.render.CCRenderState;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static final Field f_posX = ReflectionHelper.findField(FontRenderer.class, (String[])new String[]{"posX", "field_78295_j"});
    private static final Field f_posY = ReflectionHelper.findField(FontRenderer.class, (String[])new String[]{"posY", "field_78296_k"});
    private static final Method m_renderStringAtPos = ReflectionHelper.findMethod(FontRenderer.class, null, (String[])new String[]{"renderStringAtPos", "func_78255_a"}, (Class[])new Class[]{String.class, Boolean.TYPE});
    private static float lightX;
    private static float lightY;

    public static void drawTexture(double x, double y, int u, int v, int w, int h, float rotation, Gui gui) {
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glTranslatef((float)((float)w / 2.0f), (float)((float)h / 2.0f), (float)0.0f);
        GL11.glRotatef((float)(-rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)(-w) / 2.0f), (float)((float)(-h) / 2.0f), (float)0.0f);
        gui.func_73729_b(0, 0, u, v, w, h);
        GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
    }

    public static void resetColors(FontRenderer fontRenderer, int color) {
        fontRenderer.func_78276_b("", 0, 0, color);
    }

    public static void drawStringNoReset(FontRenderer fontRenderer, String s, int x, int y, boolean shadow) {
        try {
            f_posX.set(fontRenderer, x);
            f_posY.set(fontRenderer, y);
            m_renderStringAtPos.invoke((Object)fontRenderer, s, shadow);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void drawRect(int x1, int y1, int x2, int y2, int color) {
        int t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        RenderUtils.applyColorIRGBA(color);
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        tes.func_78382_b();
        tes.func_78377_a((double)x1, (double)y2, 0.0);
        tes.func_78377_a((double)x2, (double)y2, 0.0);
        tes.func_78377_a((double)x2, (double)y1, 0.0);
        tes.func_78377_a((double)x1, (double)y1, 0.0);
        tes.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawBorder(int x, int y, int width, int height) {
        GL11.glEnable((int)2852);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glLineStipple((int)4, (short)-21846);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)2);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2852);
    }

    public static void addLine(double x, double y, double x2, double y2, double linewidth) {
        Tessellator tes = Tessellator.field_78398_a;
        if (x > x2) {
            double t = x2;
            x2 = x;
            x = t;
            t = y2;
            y2 = y;
            y = t;
        }
        double g = y2 - y;
        double a = x2 - x;
        double angle = Math.atan(g / a);
        double size = linewidth / 2.0;
        double ox = Math.sin(angle) * size;
        double oy = Math.cos(angle) * size;
        tes.func_78377_a(x + ox, y - oy, 0.0);
        tes.func_78377_a(x - ox, y + oy, 0.0);
        tes.func_78377_a(x2 - ox, y2 + oy, 0.0);
        tes.func_78377_a(x2 + ox, y2 - oy, 0.0);
    }

    public static void addBox(Tessellator tes, double x1, double y1, double z1, double w, double h, double d) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        double z2 = z1 + d;
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x2, y2, z1);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x1, y1, z1);
        tes.func_78377_a(x1, y1, z1);
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x2, y2, z1);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x2, y2, z1);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x1, y1, z1);
    }

    public static void drawStringWithBorder(FontRenderer fr, String str, int x, int y, int color, int border) {
        fr.func_78276_b(str, x + 1, y, border);
        fr.func_78276_b(str, x - 1, y, border);
        fr.func_78276_b(str, x, y + 1, border);
        fr.func_78276_b(str, x, y - 1, border);
        fr.func_78276_b(str, x, y, color);
    }

    public static void drawGUIWindow(int xOffset, int yOffset, int width, int height) {
        GL11.glTranslatef((float)xOffset, (float)yOffset, (float)0.0f);
        Gui.func_73734_a((int)3, (int)3, (int)(width - 3), (int)(height - 3), (int)-3750202);
        Gui.func_73734_a((int)4, (int)0, (int)(width - 4), (int)1, (int)-16777216);
        Gui.func_73734_a((int)4, (int)1, (int)(width - 4), (int)3, (int)-1);
        Gui.func_73734_a((int)4, (int)(height - 1), (int)(width - 4), (int)height, (int)-16777216);
        Gui.func_73734_a((int)4, (int)(height - 3), (int)(width - 4), (int)(height - 1), (int)-11184811);
        Gui.func_73734_a((int)0, (int)4, (int)1, (int)(height - 4), (int)-16777216);
        Gui.func_73734_a((int)1, (int)4, (int)3, (int)(height - 4), (int)-1);
        Gui.func_73734_a((int)(width - 1), (int)4, (int)width, (int)(height - 4), (int)-16777216);
        Gui.func_73734_a((int)(width - 3), (int)4, (int)(width - 1), (int)(height - 4), (int)-11184811);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.RESOURCE_GUI_CONTROLS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        Gui.func_146110_a((int)(width - 4), (int)0, (float)4.0f, (float)0.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        Gui.func_146110_a((int)(width - 4), (int)(height - 4), (float)4.0f, (float)4.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        Gui.func_146110_a((int)0, (int)(height - 4), (float)0.0f, (float)4.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        GL11.glTranslatef((float)(-xOffset), (float)(-yOffset), (float)0.0f);
    }

    private static int[] componentsIRGBA(int arbg) {
        int red = arbg >> 16 & 0xFF;
        int blue = arbg >> 8 & 0xFF;
        int green = arbg & 0xFF;
        int alpha = arbg >> 24 & 0xFF;
        return new int[]{red, blue, green, alpha};
    }

    public static void applyColorIRGBA(Tessellator tes, int arbg, float brightness) {
        int[] rgba = RenderUtils.componentsIRGBA(arbg);
        tes.func_78370_a((int)((float)rgba[0] * brightness), (int)((float)rgba[1] * brightness), (int)((float)rgba[2] * brightness), rgba[3]);
    }

    public static void applyColorIRGBA(Tessellator tes, int arbg) {
        int[] rgba = RenderUtils.componentsIRGBA(arbg);
        tes.func_78370_a(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static void applyColorIRGBA(int arbg) {
        int[] rgba = RenderUtils.componentsIRGBA(arbg);
        GL11.glColor4f((float)((float)rgba[0] / 255.0f), (float)((float)rgba[1] / 255.0f), (float)((float)rgba[2] / 255.0f), (float)((float)rgba[3] / 255.0f));
    }

    public static void applyColorIRGB(int rbg) {
        RenderUtils.applyColorIRGB(rbg, 1.0f);
    }

    public static void applyColorIRGB(int rbg, float brightness) {
        float red = (float)(rbg >> 16 & 0xFF) / 255.0f * brightness;
        float blue = (float)(rbg >> 8 & 0xFF) / 255.0f * brightness;
        float green = (float)(rbg & 0xFF) / 255.0f * brightness;
        GL11.glColor4f((float)red, (float)blue, (float)green, (float)((float)(CCRenderState.alphaOverride > 0 ? CCRenderState.alphaOverride : 255) / 255.0f));
    }

    public static String cutStringToSize(FontRenderer fr, String str, int width) {
        if (fr.func_78256_a(str) > width) {
            int length;
            int i;
            String dots = "...";
            int dotsWidth = fr.func_78256_a(dots);
            for (i = str.length() / 2; i > 0 && (length = fr.func_78256_a(str.substring(0, i)) + dotsWidth + fr.func_78256_a(str.substring(str.length() - i, str.length()))) >= width; --i) {
            }
            str = str.substring(0, i) + dots + str.substring(str.length() - i, str.length());
        }
        return str;
    }

    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        if (OpenGlHelper.field_148823_f) {
            int fboType = (Integer)ReflectionHelper.getPrivateValue(OpenGlHelper.class, null, (String[])new String[]{"field_153212_w"});
            switch (fboType) {
                case 0: {
                    return GL30.glGetFramebufferAttachmentParameteri((int)target, (int)attachment, (int)pname);
                }
                case 1: {
                    return ARBFramebufferObject.glGetFramebufferAttachmentParameteri((int)target, (int)attachment, (int)pname);
                }
                case 2: {
                    return EXTFramebufferObject.glGetFramebufferAttachmentParameteriEXT((int)target, (int)attachment, (int)pname);
                }
            }
        }
        return 0;
    }

    public static void setBrightness(float lightX, float lightY) {
        RenderUtils.lightX = OpenGlHelper.lastBrightnessX;
        RenderUtils.lightY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightY);
    }

    public static void resetBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightY);
    }
}

