/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.net;

import codechicken.lib.vec.BlockCoord;
import java.io.IOException;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.IGate;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketBridge;
import moe.nightfall.vic.integratedcircuits.net.AbstractPacket;
import moe.nightfall.vic.integratedcircuits.net.PacketTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public abstract class PacketGate<T extends AbstractPacket<T>>
extends PacketTileEntity<T> {
    protected int facing;

    public PacketGate() {
    }

    public PacketGate(ISocketBridge.ISocketBase part) {
        BlockCoord pos = part.getPos();
        this.xCoord = pos.x;
        this.yCoord = pos.y;
        this.zCoord = pos.z;
        this.facing = part.getSide();
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        super.read(buffer);
        this.facing = buffer.readInt();
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        super.write(buffer);
        buffer.writeInt(this.facing);
    }

    protected IGate getPart(World world) {
        return IntegratedCircuitsAPI.getSocketAt(world, new BlockCoord(this.xCoord, this.yCoord, this.zCoord), this.facing).getGate();
    }
}

