/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.net.pcb;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitProperties;
import moe.nightfall.vic.integratedcircuits.net.PacketTileEntity;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityCAD;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketPCBChangeInput
extends PacketTileEntity<PacketPCBChangeInput> {
    private boolean input;
    private int[] io;
    private int con;

    public PacketPCBChangeInput() {
    }

    public PacketPCBChangeInput(boolean input, int[] io, int con, TileEntityCAD tileEntityCAD) {
        super(tileEntityCAD.field_145851_c, tileEntityCAD.field_145848_d, tileEntityCAD.field_145849_e);
        this.io = io;
        this.input = input;
        this.con = con;
        CircuitData data = tileEntityCAD.getCircuitData();
        boolean widthOK = true;
        for (int ioSide = 0; ioSide <= 3; ++ioSide) {
            widthOK = widthOK && data.maximumIOSize() >= CircuitProperties.getModeAtSide((int)con, (int)ioSide).size;
        }
        if (!widthOK) {
            Minecraft.func_71410_x().func_71377_b(new CrashReport("PCB IO mode selected for at least one side is too long.\nContact mod authors to report this error.", (Throwable)((Object)new AssertionError((Object)("PCB IO mode selected for at least one side is too long. Size of PCB is " + data.getSize() + "x" + data.getSize())))));
        }
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        super.read(buffer);
        this.input = buffer.readBoolean();
        this.con = buffer.readInt();
        this.io = new int[4];
        this.io[0] = buffer.readInt();
        this.io[1] = buffer.readInt();
        this.io[2] = buffer.readInt();
        this.io[3] = buffer.readInt();
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        super.write(buffer);
        buffer.writeBoolean(this.input);
        buffer.writeInt(this.con);
        buffer.writeInt(this.io[0]);
        buffer.writeInt(this.io[1]);
        buffer.writeInt(this.io[2]);
        buffer.writeInt(this.io[3]);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        TileEntityCAD te = (TileEntityCAD)player.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        if (te == null) {
            return;
        }
        if (this.input) {
            te.in = this.io;
        } else {
            te.out = this.io;
        }
        CircuitData data = te.getCircuitData();
        data.getProperties().setCon(this.con);
        data.clearIOAndSetupIO();
        if (this.input && side == Side.SERVER) {
            te.getCircuitData().updateInput();
            CommonProxy.networkWrapper.sendToAllAround((IMessage)this, new NetworkRegistry.TargetPoint(te.func_145831_w().func_72912_H().func_76076_i(), (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 8.0));
        }
        if (side == Side.CLIENT && Minecraft.func_71410_x().field_71462_r instanceof GuiCAD) {
            ((GuiCAD)Minecraft.func_71410_x().field_71462_r).refreshIO();
        }
    }
}

