/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.net.pcb;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.PacketTileEntity;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityCAD;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketPCBChangePart
extends PacketTileEntity<PacketPCBChangePart> {
    private List<Integer> data;
    private int button = -1;
    private boolean flag;

    public PacketPCBChangePart() {
    }

    public PacketPCBChangePart(int x, int y, int button, boolean ctrl, int tx, int ty, int tz) {
        this(ctrl, tx, ty, tz);
        this.data = Arrays.asList(x, y);
        this.button = button;
    }

    public PacketPCBChangePart(boolean flag, int tx, int ty, int tz) {
        super(tx, ty, tz);
        this.data = new ArrayList<Integer>();
        this.flag = flag;
    }

    public PacketPCBChangePart add(Vec2 pos, int id, int meta) {
        this.data.add(pos.x);
        this.data.add(pos.y);
        this.data.add(id);
        this.data.add(meta);
        return this;
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        super.read(buffer);
        this.button = buffer.readInt();
        this.flag = buffer.readBoolean();
        int size = buffer.readInt();
        this.data = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.data.add(buffer.readInt());
        }
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        super.write(buffer);
        buffer.writeInt(this.button);
        buffer.writeBoolean(this.flag);
        buffer.writeInt(this.data.size());
        for (int i : this.data) {
            buffer.writeInt(i);
        }
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        TileEntityCAD te = (TileEntityCAD)player.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        if (te != null) {
            CircuitData cdata = te.getCircuitData();
            if (this.button == -1 && this.flag) {
                te.cache.create(player.func_146103_bH().getId());
            }
            for (int i = 0; i < this.data.size(); i += 4) {
                Vec2 pos = new Vec2(this.data.get(i), this.data.get(i + 1));
                if (this.button != -1) {
                    cdata.getPart(pos).onClick(pos, te, this.button, this.flag);
                    continue;
                }
                int oid = cdata.getID(pos);
                int ometa = cdata.getMeta(pos);
                if (this.data.get(i + 2) != oid) {
                    cdata.getPart(pos).onRemoved(pos, te);
                }
                cdata.setID(pos, this.data.get(i + 2));
                cdata.setMeta(pos, this.data.get(i + 3));
                if (this.data.get(i + 2) != oid) {
                    cdata.getPart(pos).onPlaced(pos, te);
                } else if (this.data.get(i + 3) != ometa) {
                    cdata.getPart(pos).onChanged(pos, te, ometa);
                }
                cdata.markForUpdate(pos);
            }
            cdata.propagateSignals();
            if (this.button == -1 && this.flag) {
                te.cache.capture(player.func_146103_bH().getId());
            }
        }
    }
}

