/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import moe.nightfall.vic.integratedcircuits.Constants;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.DiskDrive;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.IPartRenderer;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.client.Gate7SegmentRenderer;
import moe.nightfall.vic.integratedcircuits.client.GateCircuitRenderer;
import moe.nightfall.vic.integratedcircuits.client.ItemLaserRenderer;
import moe.nightfall.vic.integratedcircuits.client.ItemPCBPrintRenderer;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.client.SemiTransparentRenderer;
import moe.nightfall.vic.integratedcircuits.client.ShaderHelper;
import moe.nightfall.vic.integratedcircuits.client.TextureRenderer;
import moe.nightfall.vic.integratedcircuits.client.TileEntityAssemblerRenderer;
import moe.nightfall.vic.integratedcircuits.client.TileEntityGateRenderer;
import moe.nightfall.vic.integratedcircuits.client.TileEntityPCBLayoutRenderer;
import moe.nightfall.vic.integratedcircuits.client.TileEntityPrinterRenderer;
import moe.nightfall.vic.integratedcircuits.client.gui.Gui7Segment;
import moe.nightfall.vic.integratedcircuits.gate.Gate7Segment;
import moe.nightfall.vic.integratedcircuits.gate.GateCircuit;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityAssembler;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityCAD;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityPrinter;
import moe.nightfall.vic.integratedcircuits.tile.TileEntitySocket;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static SemiTransparentRenderer stRenderer;
    public static Resources resources;
    public static int clientTicks;
    public static GateCircuitRenderer circuitRenderer;
    public static Gate7SegmentRenderer segmentRenderer;
    public static ItemPCBPrintRenderer pcbPrintRenderer;
    public static IPartRenderer<ISocket> socketRenderer;
    public static IPartRenderer<ISocket> socketRendererFMP;
    private static String tooltip;
    public static Map<Class<?>, IPartRenderer<?>> rendererRegistry;
    public static List<String> icons;
    public static TextureRenderer textureRenderer;
    private int curlDisplayList;
    private int annaHatDisplayList;
    Framebuffer fbo;
    Framebuffer fbo2;
    private boolean shaders = OpenGlHelper.field_148824_g;

    @Override
    public void initialize() {
        super.initialize();
        stRenderer = new SemiTransparentRenderer();
        ShaderHelper.loadShaders();
        Constants.GATE_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
        Constants.PRINTER_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
        TileEntityGateRenderer gateRenderer = new TileEntityGateRenderer();
        TileEntityPrinterRenderer printerRenderer = new TileEntityPrinterRenderer();
        RenderingRegistry.registerBlockHandler((int)Constants.GATE_RENDER_ID, (ISimpleBlockRenderingHandler)gateRenderer);
        RenderingRegistry.registerBlockHandler((int)Constants.PRINTER_RENDER_ID, (ISimpleBlockRenderingHandler)printerRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCAD.class, (TileEntitySpecialRenderer)new TileEntityPCBLayoutRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAssembler.class, (TileEntitySpecialRenderer)new TileEntityAssemblerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySocket.class, (TileEntitySpecialRenderer)gateRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPrinter.class, (TileEntitySpecialRenderer)printerRenderer);
        circuitRenderer = new GateCircuitRenderer();
        segmentRenderer = new Gate7SegmentRenderer();
        pcbPrintRenderer = new ItemPCBPrintRenderer();
        IntegratedCircuitsAPI.getGateRegistry().registerGateRenderer(GateCircuit.class, circuitRenderer);
        IntegratedCircuitsAPI.getGateRegistry().registerGateRenderer(Gate7Segment.class, segmentRenderer);
        socketRenderer = IntegratedCircuitsAPI.getGateRegistry().createDefaultSocketRenderer("integratedcircuits:ic_base");
        socketRendererFMP = IntegratedCircuitsAPI.getGateRegistry().createDefaultSocketRenderer("integratedcircuits:ic_base_fmp");
        MinecraftForgeClient.registerItemRenderer((Item)Content.itemCircuit, (IItemRenderer)circuitRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Content.item7Segment, (IItemRenderer)segmentRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Content.itemPCBPrint, (IItemRenderer)pcbPrintRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Content.itemSocket, socketRenderer);
        if (IntegratedCircuits.isFMPLoaded) {
            MinecraftForgeClient.registerItemRenderer((Item)Content.itemSocketFMP, socketRendererFMP);
        }
        MinecraftForgeClient.registerItemRenderer((Item)Content.itemLaser, (IItemRenderer)new ItemLaserRenderer());
        textureRenderer = new TextureRenderer();
        this.curlMamisHair();
        this.createAnnaHat();
    }

    @Override
    public void preInitialize() {
        super.preInitialize();
        resources = new Resources();
    }

    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        World world = event.player.field_70170_p;
        if (event.target == null || event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        AxisAlignedBB box = null;
        Block block = world.func_147439_a(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof DiskDrive.IDiskDrive) {
            box = DiskDrive.getDiskDriveBoundingBox((DiskDrive.IDiskDrive)tileEntity, x, y, z, event.target.field_72307_f);
        }
        if (tileEntity instanceof TileEntityAssembler && box == null) {
            box = (AxisAlignedBB)this.getLaserBoundingBox((TileEntityAssembler)tileEntity, x, y, z, event.player, event.partialTicks).getLeft();
        }
        if (box == null) {
            return;
        }
        double xOff = event.player.field_70142_S + (event.player.field_70165_t - event.player.field_70142_S) * (double)event.partialTicks;
        double yOff = event.player.field_70137_T + (event.player.field_70163_u - event.player.field_70137_T) * (double)event.partialTicks;
        double zOff = event.player.field_70136_U + (event.player.field_70161_v - event.player.field_70136_U) * (double)event.partialTicks;
        box = box.func_72317_d(-xOff, -yOff, -zOff).func_72314_b(0.002, 0.002, 0.002);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)-1);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.func_71410_x().field_71462_r) != null && gui.func_73868_f())) {
            ++clientTicks;
        }
    }

    public static void drawTooltip(String tooltip) {
        ClientProxy.tooltip = tooltip;
    }

    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (tooltip != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int color = (int)((Math.sin((double)((float)clientTicks + event.partialTicks) * 0.5) * 0.2 + 0.2) * 255.0 + 153.0);
            String[] splitted = MiscUtils.stringNewlineSplit(tooltip);
            int height = splitted.length * (mc.field_71466_p.field_78288_b + 2) + 6;
            for (int i = 0; i < splitted.length; ++i) {
                boolean even;
                String tooltip = splitted[i];
                int width = mc.field_71466_p.func_78256_a(tooltip);
                int x = event.resolution.func_78326_a() / 2 - width / 2;
                int y = (int)((float)(event.resolution.func_78328_b() / 2 - height / 2) + (float)i / (float)splitted.length * (float)height);
                boolean bl = even = splitted.length % 2 > 0;
                mc.field_71466_p.func_78261_a(tooltip, x, y += (float)i < (float)splitted.length / 2.0f ? (even ? -6 : 0) : (even ? 0 : 6), color << 16);
            }
            tooltip = null;
        }
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent event) {
        TextureMap map = event.map;
        switch (map.func_130086_a()) {
            case 0: {
                for (String iconString : icons) {
                    event.map.func_94245_a(iconString);
                }
                break;
            }
        }
    }

    public static void open7SegmentGUI(Gate7Segment part) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new Gui7Segment(part));
    }

    private Cosplay getCosplay(UUID uuid, String skinID) {
        String uuidStr = uuid.toString();
        if (uuidStr.equals("b027a4f4-d480-426c-84a3-a9cb029f4b72") || uuidStr.equals("6a7f2000-5853-4934-981d-5077be5a0b50") || uuidStr.equals("e2519b08-5d04-42a3-a98e-c70de4a0374e") || uuidStr.equals("eba64cb1-0d29-4434-8d5e-31004b00488c") || uuidStr.equals("3239d8f3-dd0c-48d3-890e-d3dad403f758") || uuidStr.equals("462b56b5-3047-4efd-901c-e1ecc062af30") || uuidStr.equals("edd31c45-b095-49c5-a9f5-59cec4cfed8c") || uuidStr.equals("b79043e0-b35e-4c3e-988f-42a63a2929ce")) {
            if (skinID.equals("skins/8fcd9586da356dfe3038fcad96925c43bea5b67a576c9b4e6b10f1b0bb7f1fc5")) {
                return Cosplay.SHIRO;
            }
            if (skinID.equals("skins/d45286a47c460daddedd3f02accf8b0a5b65a86dfcbffdb86e955b95e075aa")) {
                return Cosplay.JIBRIL;
            }
            if (skinID.equals("skins/7c53efc23da1887fe82b42921fcc714f76fb0e62fb032eae7039a7134e2110")) {
                return Cosplay.STEPH;
            }
            if (skinID.equals("skins/3f98d0a766e1170d389ad283860329485e5be7668bdbfe45ff04c9ba5a8a2")) {
                return Cosplay.MAMI;
            }
            if (skinID.equals("skins/23295447ce21e83e36da7360ee1fe34c15b9391fb564773c954e59c83ff6d1f9")) {
                return Cosplay.NANO;
            }
            if (skinID.equals("skins/b87e257050b59622aa2e65aeba9ea195698b625225566dd2682a77bec68398")) {
                return Cosplay.CIRNO;
            }
            if (skinID.equals("skins/4797da64c116258ba4aa30eb2cedddac4c1867e7ed8bec4907b2148f2219a81")) {
                return Cosplay.ANNA;
            }
        }
        return Cosplay.NONE;
    }

    private Cosplay getCosplay(AbstractClientPlayer player) {
        return this.getCosplay(player.func_110124_au(), player.func_110306_p().func_110623_a());
    }

    private void curlMamisHair() {
        this.curlDisplayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.curlDisplayList, (int)4864);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78371_b(8);
        tes.func_78384_a(16375429, 255);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float distance = 0.4f;
        GL11.glShadeModel((int)7425);
        float angle = 0.5f;
        while ((double)angle <= 13.571680802798028) {
            float pos = 1.0f - (float)((double)angle / 13.571680802798028) * 0.7f;
            x = (float)Math.sin(angle) * 0.1f * pos;
            z = (float)Math.cos(angle) * 0.1f * pos;
            Vec3 normals = Vec3.func_72443_a((double)x, (double)0.0, (double)z).func_72432_b();
            tes.func_78375_b((float)normals.field_72450_a, (float)normals.field_72448_b, (float)normals.field_72449_c);
            tes.func_78377_a((double)x - 0.025, (double)y - 0.025, (double)z - 0.025);
            tes.func_78377_a((double)x + 0.025, (double)y + 0.025, (double)z + 0.025);
            y = (float)((double)y + 0.01);
            angle += distance;
        }
        tes.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glEndList();
    }

    public void renderPlayer(float partial, RenderGlobal context) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            int currentFBO = GL11.glGetInteger((int)36006);
            int currentTexture = RenderUtils.glGetFramebufferAttachmentParameteri(36160, 36064, 36049);
            if (OpenGlHelper.func_148822_b() && this.shaders && ShaderHelper.SHADER_BLUR != 0) {
                if (this.fbo == null || this.fbo2 == null) {
                    this.fbo = new Framebuffer(mc.field_71443_c, mc.field_71440_d, false);
                    this.fbo.func_147604_a(0.0f, 0.0f, 0.0f, 1.0f);
                    this.fbo.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                    this.fbo.func_147609_e();
                    this.fbo2 = new Framebuffer(mc.field_71443_c, mc.field_71440_d, false);
                    this.fbo2.func_147604_a(0.0f, 0.0f, 0.0f, 1.0f);
                    this.fbo2.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                    this.fbo2.func_147609_e();
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)currentFBO);
                } else if (mc.field_71443_c != this.fbo.field_147621_c || mc.field_71440_d != this.fbo.field_147618_d) {
                    this.fbo.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                    this.fbo.func_147609_e();
                    this.fbo2.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                    this.fbo2.func_147609_e();
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)currentFBO);
                }
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)this.fbo.field_147617_g, (int)0);
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                int error = GL11.glGetError();
                if (error != 0) {
                    IntegratedCircuits.logger.warn("Shaders not supported, disabling aura effect :(");
                    this.shaders = false;
                    return;
                }
            } else {
                GL11.glShadeModel((int)7425);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
            }
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            WorldClient world = mc.field_71441_e;
            EntityLivingBase entityLiving = mc.field_71451_h;
            double x = entityLiving.field_70169_q + (entityLiving.field_70165_t - entityLiving.field_70169_q) * (double)partial;
            double y = entityLiving.field_70167_r + (entityLiving.field_70163_u - entityLiving.field_70167_r) * (double)partial;
            double z = entityLiving.field_70166_s + (entityLiving.field_70161_v - entityLiving.field_70166_s) * (double)partial;
            Frustrum frustrum = new Frustrum();
            frustrum.func_78547_a(x, y, z);
            boolean found = false;
            List list = world.field_72996_f;
            for (Entity entity : list) {
                EntityLiving entityliving;
                boolean flag;
                AbstractClientPlayer player;
                if (!(entity instanceof AbstractClientPlayer) || (player = (AbstractClientPlayer)entity).func_82150_aj() || this.getCosplay(player) != Cosplay.CIRNO) continue;
                boolean bl = flag = entity.func_145770_h(x, y, z) && (entity.field_70158_ak || frustrum.func_78546_a(entity.field_70121_D) || entity.field_70153_n == mc.field_71439_g);
                if (!flag && entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).func_110167_bD() && entityliving.func_110166_bE() != null) {
                    Entity entity1 = entityliving.func_110166_bE();
                    flag = frustrum.func_78546_a(entity1.field_70121_D);
                }
                if (!flag || entity == mc.field_71451_h && mc.field_71474_y.field_74320_O == 0 && !mc.field_71451_h.func_70608_bn() || !world.func_72899_e(MathHelper.func_76128_c((double)entity.field_70165_t), 0, MathHelper.func_76128_c((double)entity.field_70161_v))) continue;
                found = true;
                GL11.glPushMatrix();
                GL11.glColor3f((float)0.0f, (float)((float)((Math.sin((double)((float)player.field_70173_aa + partial) / 20.0) + 1.0) * 0.2)), (float)1.0f);
                RenderManager rm = RenderManager.field_78727_a;
                double x2 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial - RenderManager.field_78725_b;
                double y2 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial - RenderManager.field_78726_c;
                double z2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial - RenderManager.field_78723_d;
                float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partial;
                int i = entity.func_70070_b(partial);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
                RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a(entity);
                if (render != null && rm.field_78724_e != null && !render.func_147905_a()) {
                    float f4;
                    ItemStack itemstack = player.field_71071_by.func_70448_g();
                    int n = render.field_77109_a.field_78120_m = itemstack != null ? 1 : 0;
                    if (itemstack != null && player.func_71052_bv() > 0) {
                        EnumAction enumaction = itemstack.func_77975_n();
                        if (enumaction == EnumAction.block) {
                            render.field_77109_a.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            render.field_77109_a.field_78118_o = true;
                        }
                    }
                    render.field_77109_a.field_78117_n = player.func_70093_af();
                    if (player.func_70093_af() && !(player instanceof EntityPlayerSP)) {
                        y2 -= 0.125;
                    }
                    float f2 = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partial;
                    float f3 = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partial;
                    if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
                        EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
                        f2 = player.field_70760_ar + (entitylivingbase1.field_70761_aq - entitylivingbase1.field_70760_ar) * partial;
                        f4 = MathHelper.func_76142_g((float)(f3 - f2));
                        f4 = MathHelper.func_76131_a((float)f4, (float)-85.0f, (float)85.0f);
                        f2 = f3 - f4;
                        if (f4 * f4 > 2500.0f) {
                            f2 += f4 * 0.2f;
                        }
                    }
                    float f13 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partial;
                    f4 = (float)player.field_70173_aa + partial;
                    ReflectionHelper.findMethod(RenderPlayer.class, (Object)render, (String[])new String[]{"renderLivingAt", "func_77039_a"}, (Class[])new Class[]{EntityLivingBase.class, Double.TYPE, Double.TYPE, Double.TYPE}).invoke((Object)render, entity, x2, y2, z2);
                    ReflectionHelper.findMethod(RenderPlayer.class, (Object)render, (String[])new String[]{"rotateCorpse", "func_77043_a"}, (Class[])new Class[]{EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE}).invoke((Object)render, entity, Float.valueOf(f4), Float.valueOf(f2), Float.valueOf(partial));
                    float tilt = 0.0625f;
                    float limbSwing = player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * partial;
                    float limbSwing2 = player.field_70754_ba - player.field_70721_aZ * (1.0f - partial);
                    if (player.func_70631_g_()) {
                        limbSwing2 *= 3.0f;
                    }
                    if (limbSwing > 1.0f) {
                        limbSwing = 1.0f;
                    }
                    GL11.glTranslatef((float)0.0f, (float)(player.eyeHeight - 0.375f), (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    render.field_77109_a.func_78087_a(limbSwing2, limbSwing, f4, f3 - f2, f13, tilt, entity);
                    render.field_77109_a.field_78115_e.func_78785_a(tilt);
                    render.field_77109_a.field_78112_f.field_82906_o = 0.03125f;
                    render.field_77109_a.field_78112_f.func_78785_a(tilt);
                    render.field_77109_a.field_78113_g.field_82906_o = -0.03125f;
                    render.field_77109_a.field_78113_g.func_78785_a(tilt);
                    render.field_77109_a.field_78124_i.field_82908_p = -0.03125f;
                    render.field_77109_a.field_78123_h.field_82908_p = -0.03125f;
                    if (player.func_70093_af()) {
                        render.field_77109_a.field_78124_i.field_82907_q = -0.015625f;
                        render.field_77109_a.field_78123_h.field_82907_q = -0.015625f;
                    }
                    render.field_77109_a.field_78123_h.func_78785_a(tilt);
                    render.field_77109_a.field_78124_i.func_78785_a(tilt);
                    render.field_77109_a.field_78114_d.field_82908_p = 0.0625f;
                    render.field_77109_a.field_78114_d.func_78785_a(tilt);
                    render.field_77109_a.field_78113_g.field_82906_o = 0.0f;
                    render.field_77109_a.field_78112_f.field_82906_o = 0.0f;
                    render.field_77109_a.field_78124_i.field_82908_p = 0.0f;
                    render.field_77109_a.field_78123_h.field_82908_p = 0.0f;
                    render.field_77109_a.field_78124_i.field_82907_q = 0.0f;
                    render.field_77109_a.field_78123_h.field_82907_q = 0.0f;
                    render.field_77109_a.field_78114_d.field_82908_p = 0.0f;
                }
                double scale = 1.2 + (Math.sin((double)((float)player.field_70173_aa + partial) / 20.0) + 1.0) * 0.02;
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)3553);
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)currentTexture, (int)0);
            if (OpenGlHelper.func_148822_b() && this.shaders && ShaderHelper.SHADER_BLUR != 0 && found) {
                GL11.glMatrixMode((int)5889);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                this.fbo2.func_147610_a(false);
                this.fbo.func_147612_c();
                ShaderHelper.bindShader(ShaderHelper.SHADER_BLUR);
                ARBShaderObjects.glUniform2fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)ShaderHelper.SHADER_BLUR, (CharSequence)"uShift"), (float)(2.0f / (float)this.fbo.field_147621_c), (float)0.0f);
                for (int i = 0; i < 6; ++i) {
                    if (i == 1) {
                        this.fbo2.func_147612_c();
                    }
                    if (i == 3) {
                        ARBShaderObjects.glUniform2fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)ShaderHelper.SHADER_BLUR, (CharSequence)"uShift"), (float)0.0f, (float)(2.0f / (float)this.fbo.field_147618_d));
                    }
                    Tessellator tes = Tessellator.field_78398_a;
                    tes.func_78382_b();
                    tes.func_78374_a(-1.0, -1.0, 0.0, 0.0, 0.0);
                    tes.func_78374_a(1.0, -1.0, 0.0, 1.0, 0.0);
                    tes.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
                    tes.func_78374_a(-1.0, 1.0, 0.0, 0.0, 1.0);
                    tes.func_78381_a();
                }
                ShaderHelper.releaseShader();
                this.fbo.func_147614_f();
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)currentFBO);
                this.fbo2.func_147612_c();
                GL11.glShadeModel((int)7425);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                Tessellator tes = Tessellator.field_78398_a;
                tes.func_78382_b();
                tes.func_78374_a(-1.0, -1.0, 0.0, 0.0, 0.0);
                tes.func_78374_a(1.0, -1.0, 0.0, 1.0, 0.0);
                tes.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
                tes.func_78374_a(-1.0, 1.0, 0.0, 0.0, 1.0);
                tes.func_78381_a();
                int error = GL11.glGetError();
                if (error != 0) {
                    IntegratedCircuits.logger.warn("Shaders not supported, disabling aura effect :(");
                    this.shaders = false;
                    return;
                }
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5889);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7424);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Specials.Post event) {
        boolean hideThing;
        EntityPlayer player = event.entityPlayer;
        Minecraft mc = Minecraft.func_71410_x();
        Cosplay cosplay = Cosplay.NONE;
        if (player instanceof AbstractClientPlayer) {
            cosplay = this.getCosplay((AbstractClientPlayer)player);
        }
        if (cosplay == Cosplay.NONE) {
            return;
        }
        boolean bl = hideThing = player.field_71071_by.func_70440_f(3) != null && (cosplay == Cosplay.SHIRO || cosplay == Cosplay.STEPH || cosplay == Cosplay.MAMI);
        if (IntegratedCircuits.isAWLoaded) {
            try {
                Object skinInfo;
                Object nakedInfo;
                BitSet armourOverride;
                Object epRenderCache = Class.forName("riskyken.armourersWorkshop.client.handler.PlayerSkinHandler").getDeclaredField("INSTANCE").get(null);
                Field f = epRenderCache.getClass().getDeclaredField("skinMap");
                f.setAccessible(true);
                Map skinMap = (Map)f.get(epRenderCache);
                if (skinMap.containsKey(player.getPersistentID()) && (armourOverride = (BitSet)(nakedInfo = (skinInfo = skinMap.get(player.getPersistentID())).getClass().getMethod("getNakedInfo", new Class[0]).invoke(skinInfo, new Object[0])).getClass().getDeclaredField("armourOverride").get(nakedInfo)).get(0)) {
                    hideThing = false;
                }
            }
            catch (Exception epRenderCache) {
                // empty catch block
            }
        }
        if (hideThing) {
            return;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (cosplay == Cosplay.NANO) {
            int jumpTime;
            boolean isJumping;
            long time = System.currentTimeMillis();
            NanoProperties properties = (NanoProperties)event.entityPlayer.getExtendedProperties("nano");
            if (properties == null) {
                properties = new NanoProperties();
                player.registerExtendedProperties("nano", (IExtendedEntityProperties)properties);
            }
            boolean bl2 = isJumping = player.field_70163_u - player.field_70137_T > (double)player.field_70747_aH;
            if (isJumping && !properties.isJumping) {
                properties.lastJumpStart = System.currentTimeMillis();
            } else if (!isJumping && properties.isJumping && (jumpTime = (int)(time - properties.lastJumpStart)) > 150 && jumpTime < 450) {
                if (!properties.isSpinning && time - properties.lastJump < 1200L && Math.random() < 0.5 && time - properties.lastSpin > 10000L) {
                    properties.lastSpin = time;
                    properties.isSpinning = true;
                }
                properties.lastJump = time;
            }
            properties.isJumping = isJumping;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(-event.renderer.field_77109_a.field_78115_e.field_78795_f)), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.1875f, (float)0.0f, (float)0.0625f);
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)-0.0625f);
            if (properties.isSpinning) {
                double t = time - properties.lastSpin;
                float angle = (float)(Math.sin(t / 50.0) * 20.0 + 0.2 * t);
                GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
                if (angle >= 360.0f) {
                    properties.isSpinning = false;
                }
            }
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0625f);
            mc.field_71446_o.func_110577_a(Resources.RESOURCE_MISC_NANO);
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)32, (int)32, (float)0.125f);
            GL11.glPopMatrix();
            return;
        }
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * event.partialRenderTick;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.partialRenderTick;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.partialRenderTick;
        float pitchZ = (float)Math.toDegrees(event.renderer.field_77109_a.field_78116_c.field_78808_h);
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)pitchZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)(player.func_70093_af() ? 0.0625 : 0.0), (double)0.0);
        Tessellator tes = Tessellator.field_78398_a;
        switch (cosplay) {
            case JIBRIL: {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glShadeModel((int)7425);
                RenderUtils.setBrightness(240.0f, 240.0f);
                GL11.glDisable((int)2896);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(Resources.RESOURCE_MISC_HALO);
                GL11.glRotated((double)30.0, (double)1.0, (double)0.0, (double)-1.0);
                GL11.glTranslatef((float)-0.1f, (float)-0.62f, (float)-0.1f);
                GL11.glRotatef((float)((float)player.field_70173_aa + event.partialRenderTick), (float)0.0f, (float)1.0f, (float)0.0f);
                tes.func_78382_b();
                tes.func_78374_a(-0.5, 0.0, -0.5, 0.0, 0.0);
                tes.func_78374_a(-0.5, 0.0, 0.5, 0.0, 1.0);
                tes.func_78374_a(0.5, 0.0, 0.5, 1.0, 1.0);
                tes.func_78374_a(0.5, 0.0, -0.5, 1.0, 0.0);
                tes.func_78381_a();
                GL11.glEnable((int)2896);
                GL11.glShadeModel((int)7424);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                RenderUtils.resetBrightness();
                break;
            }
            case SHIRO: {
                GL11.glPushMatrix();
                float scale = 0.015625f;
                GL11.glTranslated((double)(15.0f * scale), (double)-0.78, (double)(15.0f * scale));
                float f1 = (float)(7.0 * Math.sin(Math.toRadians(45.0)) + 3.5) * scale;
                GL11.glTranslatef((float)(-f1), (float)0.0f, (float)(-f1));
                GL11.glRotated((double)-25.0, (double)1.0, (double)0.0, (double)-1.0);
                GL11.glTranslatef((float)f1, (float)0.0f, (float)f1);
                GL11.glEnable((int)2884);
                ModelCrown.instance.render(scale);
                GL11.glDisable((int)2884);
                GL11.glPopMatrix();
                break;
            }
            case STEPH: {
                mc.field_71446_o.func_110577_a(Resources.RESOURCE_MISC_EARS);
                ModelDogEars.instance.render(pitch, player.field_70759_as - player.field_70758_at);
                GameData.getBlockRegistry().func_82594_a(player.func_70005_c_());
                break;
            }
            case MAMI: {
                GL11.glDisable((int)3553);
                this.renderCurl();
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                this.renderCurl();
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                this.renderHat();
                GL11.glEnable((int)3553);
                mc.field_71446_o.func_110577_a(Resources.RESOURCE_MISC_FLOWER);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-0.5625f, (float)0.0f);
                GL11.glTranslatef((float)0.125f, (float)0.0f, (float)-0.20625f);
                GL11.glRotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tes.func_78382_b();
                tes.func_78374_a(-0.125, 0.0, -0.125, 0.0, 0.0);
                tes.func_78374_a(-0.125, 0.0, 0.125, 0.0, 1.0);
                tes.func_78374_a(0.125, 0.0, 0.125, 1.0, 1.0);
                tes.func_78374_a(0.125, 0.0, -0.125, 1.0, 0.0);
                tes.func_78381_a();
                GL11.glPopMatrix();
                mc.field_71446_o.func_110577_a(Resources.RESOURCE_MISC_FLUFF);
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.0625f, (float)-0.5f, (float)-0.3125f);
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                tes.func_78382_b();
                tes.func_78374_a(0.0, -0.1875, -0.1875, 0.0, 0.0);
                tes.func_78374_a(0.0, 0.1875, -0.1875, 0.0, 1.0);
                tes.func_78374_a(0.0, 0.1875, 0.1875, 1.0, 1.0);
                tes.func_78374_a(0.0, -0.1875, 0.1875, 1.0, 0.0);
                tes.func_78381_a();
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
                break;
            }
            case ANNA: {
                GL11.glPushMatrix();
                float scale = 0.015625f;
                GL11.glTranslated((double)(15.0f * scale), (double)-0.74, (double)(15.0f * scale));
                float f1 = (float)(7.0 * Math.sin(Math.toRadians(45.0)) + 3.5) * scale;
                GL11.glTranslatef((float)(-f1), (float)0.0f, (float)(-f1));
                GL11.glRotated((double)-25.0, (double)1.0, (double)0.0, (double)-1.0);
                GL11.glTranslatef((float)f1, (float)0.0f, (float)f1);
                GL11.glCallList((int)this.annaHatDisplayList);
                GL11.glPopMatrix();
                break;
            }
        }
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderCurl() {
        GL11.glPushMatrix();
        GL11.glRotatef((float)40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.1875f, (float)0.09375f, (float)0.21875f);
        GL11.glCallList((int)this.curlDisplayList);
        GL11.glPopMatrix();
    }

    private void renderHat() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.625f, (float)0.0f);
        float radius = 0.25f;
        float height = 0.125f;
        float res = 0.7f;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78371_b(6);
        tes.func_78384_a(5718607, 255);
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        tes.func_78377_a(0.0, 0.0, 0.0);
        float i = 0.0f;
        while ((double)i <= Math.PI * 2) {
            tes.func_78377_a((double)radius * Math.cos(i), 0.0, (double)radius * Math.sin(i));
            i += res;
        }
        tes.func_78377_a((double)radius, 0.0, 0.0);
        tes.func_78381_a();
        Vec3 center = Vec3.func_72443_a((double)(-radius), (double)(-height / 2.0f), (double)(-radius));
        tes.func_78371_b(8);
        tes.func_78384_a(5718607, 255);
        float i2 = 0.0f;
        while ((double)i2 <= Math.PI * 2) {
            float x = (float)((double)radius * Math.cos(i2));
            float z = (float)((double)radius * Math.sin(i2));
            Vec3 v1 = Vec3.func_72443_a((double)x, (double)0.0, (double)z).func_72444_a(center).func_72432_b();
            tes.func_78375_b((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c);
            tes.func_78377_a((double)x, 0.0, (double)z);
            Vec3 v2 = Vec3.func_72443_a((double)x, (double)height, (double)z).func_72444_a(center).func_72432_b();
            tes.func_78375_b((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c);
            tes.func_78377_a((double)x, (double)height, (double)z);
            i2 += res;
        }
        tes.func_78377_a((double)radius, 0.0, 0.0);
        tes.func_78377_a((double)radius, (double)height, 0.0);
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    private void createAnnaHat() {
        float angle;
        int i;
        this.annaHatDisplayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.annaHatDisplayList, (int)4864);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glScalef((float)0.015625f, (float)0.015625f, (float)0.015625f);
        GL11.glColor3ub((byte)-128, (byte)0, (byte)0);
        GL11.glShadeModel((int)7425);
        Tessellator tes = Tessellator.field_78398_a;
        float height = 9.0f;
        float inner = 11.0f;
        float outer = 18.0f;
        int points = 12;
        tes.func_78371_b(8);
        for (i = 0; i <= points; ++i) {
            angle = (float)Math.PI * 2 * ((float)i + 0.5f) / (float)points;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            tes.func_78375_b(0.95f * cos, -0.31225f, 0.95f * sin);
            tes.func_78377_a((double)(inner * cos), 0.0, (double)(inner * sin));
            tes.func_78377_a((double)(inner * cos), (double)height, (double)(inner * sin));
        }
        tes.func_78381_a();
        tes.func_78371_b(6);
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        tes.func_78377_a(0.0, 0.0, 0.0);
        for (i = 0; i <= points; ++i) {
            angle = (float)Math.PI * 2 * ((float)i + 0.5f) / (float)points;
            tes.func_78377_a((double)inner * Math.cos(angle), 0.0, (double)inner * Math.sin(angle));
        }
        tes.func_78381_a();
        tes.func_78371_b(6);
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        tes.func_78377_a(0.0, (double)height, 0.0);
        for (i = 0; i <= points; ++i) {
            angle = (float)Math.PI * 2 * ((float)i + 0.5f) / (float)points;
            tes.func_78377_a((double)outer * Math.cos(angle), (double)height, (double)outer * Math.sin(angle));
        }
        tes.func_78381_a();
        tes.func_78371_b(6);
        tes.func_78375_b(0.0f, 1.0f, 0.0f);
        tes.func_78377_a(0.0, (double)height, 0.0);
        for (i = 0; i <= points; ++i) {
            angle = (float)Math.PI * 2 * -((float)i + 0.5f) / (float)points;
            tes.func_78377_a((double)outer * Math.cos(angle), (double)height, (double)outer * Math.sin(angle));
        }
        tes.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2884);
        GL11.glEndList();
    }

    static {
        rendererRegistry = Maps.newHashMap();
        icons = Lists.newArrayList();
    }

    private static class NanoProperties
    implements IExtendedEntityProperties {
        private boolean isJumping;
        private long lastJumpStart;
        private long lastJump;
        private long lastSpin;
        private boolean isSpinning;

        private NanoProperties() {
        }

        public void saveNBTData(NBTTagCompound compound) {
        }

        public void loadNBTData(NBTTagCompound compound) {
        }

        public void init(Entity entity, World world) {
        }
    }

    public static class ModelDogEars
    extends ModelBase {
        public static ModelDogEars instance = new ModelDogEars();
        public ModelRenderer ear;

        public ModelDogEars() {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            this.ear = new ModelRenderer((ModelBase)this);
            this.ear.func_78789_a(0.0f, 0.0f, 0.0f, 3, 9, 1);
        }

        public void render(float pitch, float off) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)-0.3125f);
            GL11.glTranslatef((float)0.09375f, (float)0.0f, (float)0.03125f);
            GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (off < 0.0f) {
                GL11.glRotatef((float)off, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)-0.09375f, (float)0.0f, (float)-0.03125f);
            this.ear.func_78785_a(0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.25f);
            GL11.glTranslatef((float)0.09375f, (float)0.0f, (float)0.03125f);
            GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (off > 0.0f) {
                GL11.glRotatef((float)off, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)-0.09375f, (float)0.0f, (float)-0.03125f);
            this.ear.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
    }

    public static class ModelCrown
    extends ModelBase {
        public static ModelCrown instance = new ModelCrown();
        public ModelRenderer crown1;
        public ModelRenderer crown2;

        public ModelCrown() {
            int i1 = 7;
            int i2 = 18;
            this.field_78090_t = i1 * 2;
            this.field_78089_u = i2;
            float f1 = -((float)i1 / 2.0f);
            float f2 = (float)((double)i1 * Math.sin(Math.toRadians(45.0)) + (double)((float)i1 / 2.0f));
            this.crown1 = new ModelRenderer((ModelBase)this);
            this.crown1.func_78784_a(0, 0);
            this.crown1.func_78789_a(f1, 0.0f, -f2, i1, i2, 0);
            this.crown1.func_78784_a(7, 0);
            this.crown1.func_78789_a(f1, 0.0f, f2, i1, i2, 0);
            this.crown1.func_78784_a(0, -7);
            this.crown1.func_78789_a(-f2, 0.0f, f1, 0, i2, i1);
            this.crown1.func_78784_a(7, -7);
            this.crown1.func_78789_a(f2, 0.0f, f1, 0, i2, i1);
            this.crown1.field_78796_g = (float)Math.toRadians(30.0);
            this.crown2 = new ModelRenderer((ModelBase)this);
            this.crown2.func_78784_a(7, 0);
            this.crown2.func_78789_a(f1, 0.0f, -f2, i1, i2, 0);
            this.crown2.func_78784_a(0, 0);
            this.crown2.func_78789_a(f1, 0.0f, f2, i1, i2, 0);
            this.crown2.func_78784_a(7, -7);
            this.crown2.func_78789_a(-f2, 0.0f, f1, 0, i2, i1);
            this.crown2.func_78784_a(0, -7);
            this.crown2.func_78789_a(f2, 0.0f, f1, 0, i2, i1);
            this.crown2.field_78796_g = (float)Math.toRadians(75.0);
        }

        public void render(float scale) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.RESOURCE_MISC_CROWN);
            this.crown1.func_78785_a(scale);
            this.crown2.func_78785_a(scale);
        }
    }

    private static enum Cosplay {
        NONE,
        SHIRO,
        JIBRIL,
        STEPH,
        MAMI,
        NANO,
        CIRNO,
        ANNA;

    }
}

