/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.proxy;

import codechicken.lib.vec.BlockCoord;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.DiskDrive;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.LaserHelper;
import moe.nightfall.vic.integratedcircuits.client.gui.IntegratedCircuitsGuiHandler;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RayTracer;
import moe.nightfall.vic.integratedcircuits.net.AbstractPacket;
import moe.nightfall.vic.integratedcircuits.net.MCDataOutputImpl;
import moe.nightfall.vic.integratedcircuits.net.Packet7SegmentChangeMode;
import moe.nightfall.vic.integratedcircuits.net.Packet7SegmentOpenGui;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerChangeItem;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerChangeLaser;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerStart;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerUpdate;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerUpdateInsufficient;
import moe.nightfall.vic.integratedcircuits.net.PacketChangeSetting;
import moe.nightfall.vic.integratedcircuits.net.PacketDataStream;
import moe.nightfall.vic.integratedcircuits.net.PacketFloppyDisk;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBCache;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangeInput;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangeName;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangePart;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBClear;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBComment;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBDeleteComment;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBLoad;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBPrint;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBSaveLoad;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBSimulation;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBUpdate;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityAssembler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CommonProxy {
    public static int serverTicks;
    public static SimpleNetworkWrapper networkWrapper;
    private static HashMap<World, HashMap<SidedBlockCoord, MCDataOutputImpl>> out;

    public void initialize() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)IntegratedCircuits.instance, (IGuiHandler)new IntegratedCircuitsGuiHandler());
    }

    public void preInitialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("integratedcircuits");
        IntegratedCircuits.logger.debug("[Common Proxy]: Registering network packets");
        AbstractPacket.registerPacket(PacketPCBUpdate.class, Side.CLIENT, 0);
        AbstractPacket.registerPacket(PacketPCBChangePart.class, Side.SERVER, 1);
        AbstractPacket.registerPacket(PacketPCBClear.class, null, 2);
        AbstractPacket.registerPacket(PacketPCBChangeName.class, null, 3);
        AbstractPacket.registerPacket(PacketPCBSaveLoad.class, Side.SERVER, 4);
        AbstractPacket.registerPacket(PacketPCBChangeInput.class, null, 5);
        AbstractPacket.registerPacket(PacketPCBLoad.class, Side.CLIENT, 6);
        AbstractPacket.registerPacket(PacketPCBCache.class, Side.SERVER, 7);
        AbstractPacket.registerPacket(PacketPCBComment.class, null, 18);
        AbstractPacket.registerPacket(PacketPCBDeleteComment.class, null, 19);
        AbstractPacket.registerPacket(PacketPCBSimulation.class, null, 20);
        AbstractPacket.registerPacket(PacketPCBPrint.class, Side.SERVER, 21);
        AbstractPacket.registerPacket(PacketAssemblerStart.class, null, 8);
        AbstractPacket.registerPacket(PacketAssemblerUpdate.class, Side.CLIENT, 9);
        AbstractPacket.registerPacket(PacketAssemblerChangeLaser.class, Side.CLIENT, 10);
        AbstractPacket.registerPacket(PacketAssemblerChangeItem.class, Side.CLIENT, 11);
        AbstractPacket.registerPacket(PacketAssemblerUpdateInsufficient.class, Side.CLIENT, 12);
        AbstractPacket.registerPacket(PacketChangeSetting.class, null, 13);
        AbstractPacket.registerPacket(PacketFloppyDisk.class, Side.CLIENT, 14);
        AbstractPacket.registerPacket(Packet7SegmentOpenGui.class, Side.CLIENT, 15);
        AbstractPacket.registerPacket(Packet7SegmentChangeMode.class, null, 16);
        AbstractPacket.registerPacket(PacketDataStream.class, Side.CLIENT, 17);
    }

    public synchronized MCDataOutputImpl addStream(World world, BlockCoord crd, int side) {
        HashMap<SidedBlockCoord, MCDataOutputImpl> map;
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Cannot use getWriteStream on a client world");
        }
        SidedBlockCoord scrd = new SidedBlockCoord(crd.x, crd.y, crd.z, side);
        if (!out.containsKey(world)) {
            out.put(world, new HashMap());
        }
        if ((map = out.get(world)).containsKey(scrd)) {
            networkWrapper.sendToDimension((IMessage)new PacketDataStream(map.remove(scrd), scrd.x, scrd.y, scrd.z, scrd.side), world.field_73011_w.field_76574_g);
        }
        MCDataOutputImpl stream = new MCDataOutputImpl(new ByteArrayOutputStream());
        map.put(scrd, stream);
        return stream;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++serverTicks;
            for (World world : out.keySet()) {
                HashMap<SidedBlockCoord, MCDataOutputImpl> map = out.get(world);
                for (Map.Entry<SidedBlockCoord, MCDataOutputImpl> entry : map.entrySet()) {
                    SidedBlockCoord crd = entry.getKey();
                    networkWrapper.sendToDimension((IMessage)new PacketDataStream(map.get(crd), crd.x, crd.y, crd.z, crd.side), world.field_73011_w.field_76574_g);
                }
                map.clear();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        if (Config.showStartupMessage) {
            ChatComponentText text = new ChatComponentText("[Integrated Circuits] This is an extremely early alpha version so please report any bugs occuring to the ");
            ChatComponentText url = new ChatComponentText("GitHub");
            url.func_150256_b().func_150228_d(Boolean.valueOf(true));
            url.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
            url.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Click to visit ICs GitHub repo")));
            url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Victorious3/Integrated-Circuits"));
            text.func_150257_a((IChatComponent)url);
            text.func_150258_a(" repo.");
            if (event.player.func_70003_b(MinecraftServer.func_71276_C().func_110455_j(), null)) {
                text.func_150258_a(" You can disable this message by changing the config file. Thanks for your attention.");
            }
            event.player.func_146105_b((IChatComponent)text);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        TileEntityAssembler assembler;
        Pair<AxisAlignedBB, Integer> result;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        if (!block.hasTileEntity(event.world.func_72805_g(event.x, event.y, event.z))) {
            return;
        }
        TileEntity te = event.world.func_147438_o(event.x, event.y, event.z);
        if (te instanceof DiskDrive.IDiskDrive) {
            DiskDrive.IDiskDrive drive = (DiskDrive.IDiskDrive)te;
            ItemStack stack = event.entityPlayer.func_71045_bC();
            MovingObjectPosition target = RayTracer.rayTrace(event.entityPlayer, 1.0f);
            if (target == null) {
                return;
            }
            AxisAlignedBB box = DiskDrive.getDiskDriveBoundingBox(drive, event.x, event.y, event.z, target.field_72307_f);
            if (box != null) {
                if (!event.world.field_72995_K) {
                    if (stack == null) {
                        ItemStack floppy = drive.getDisk();
                        drive.setDisk(null);
                        event.entityPlayer.func_70062_b(0, floppy);
                    } else if (stack.func_77973_b() != null && stack.func_77973_b() == Content.itemFloppyDisk && drive.getDisk() == null) {
                        drive.setDisk(stack);
                        event.entityPlayer.func_70062_b(0, null);
                    }
                }
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
        if (te instanceof TileEntityAssembler && (result = this.getLaserBoundingBox(assembler = (TileEntityAssembler)te, event.x, event.y, event.z, event.entityPlayer, 1.0f)).getLeft() != null) {
            if (!event.world.field_72995_K) {
                ItemStack holding;
                ItemStack stack2 = holding = event.entityPlayer.func_70694_bm();
                if (holding != null) {
                    stack2 = holding.func_77946_l();
                    stack2.field_77994_a = 1;
                }
                assembler.laserHelper.createLaser((Integer)result.getRight(), stack2);
                if (holding == null) {
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, new ItemStack(Content.itemLaser));
                } else if (holding.func_77973_b() == Content.itemLaser) {
                    --holding.field_77994_a;
                    if (holding.field_77994_a <= 0) {
                        holding = null;
                    }
                }
            }
            event.useBlock = Event.Result.DENY;
            event.useItem = Event.Result.DENY;
        }
    }

    public Pair<AxisAlignedBB, Integer> getLaserBoundingBox(TileEntityAssembler te, int x, int y, int z, EntityPlayer player, float partialTicks) {
        MovingObjectPosition mop;
        LaserHelper.Laser l4;
        LaserHelper.Laser l3;
        LaserHelper.Laser l2;
        boolean holdsEmpty;
        if (te.getStatus() == 1 || !player.func_70093_af()) {
            return new ImmutablePair(null, null);
        }
        boolean bl = holdsEmpty = player.func_70694_bm() == null;
        boolean holdsLaser = !holdsEmpty ? player.func_70694_bm().func_77973_b() == Content.itemLaser : false;
        AxisAlignedBB base = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB boxBase = AxisAlignedBB.func_72330_a((double)0.6875, (double)0.5, (double)0.6875, (double)0.9375, (double)0.9375, (double)0.9375);
        AxisAlignedBB box1 = null;
        AxisAlignedBB box2 = null;
        AxisAlignedBB box3 = null;
        AxisAlignedBB box4 = null;
        LaserHelper.Laser l1 = te.laserHelper.getLaser((te.rotation + 0) % 4);
        if (l1 != null && holdsEmpty || holdsLaser && l1 == null) {
            box1 = MiscUtils.getRotatedInstance(boxBase, 2).func_72317_d((double)x, (double)y, (double)z);
        }
        if ((l2 = te.laserHelper.getLaser((te.rotation + 1) % 4)) != null && holdsEmpty || holdsLaser && l2 == null) {
            box2 = MiscUtils.getRotatedInstance(boxBase, 1).func_72317_d((double)x, (double)y, (double)z);
        }
        if ((l3 = te.laserHelper.getLaser((te.rotation + 2) % 4)) != null && holdsEmpty || holdsLaser && l3 == null) {
            box3 = MiscUtils.getRotatedInstance(boxBase, 0).func_72317_d((double)x, (double)y, (double)z);
        }
        if ((l4 = te.laserHelper.getLaser((te.rotation + 3) % 4)) != null && holdsEmpty || holdsLaser && l4 == null) {
            box4 = MiscUtils.getRotatedInstance(boxBase, 3).func_72317_d((double)x, (double)y, (double)z);
        }
        if ((mop = RayTracer.rayTraceAABB(player, partialTicks, base, box1, box2, box3, box4)) == null || mop.hitInfo == base) {
            return new ImmutablePair(null, null);
        }
        int id = (te.rotation + (mop.hitInfo == box1 ? 0 : (mop.hitInfo == box2 ? 1 : (mop.hitInfo == box3 ? 2 : (mop.hitInfo == box4 ? 3 : 0))))) % 4;
        return new ImmutablePair((Object)((AxisAlignedBB)mop.hitInfo), (Object)id);
    }

    static {
        out = Maps.newHashMap();
    }

    private static class SidedBlockCoord {
        public int x;
        public int y;
        public int z;
        public int side;

        public SidedBlockCoord(int x, int y, int z, int side) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.side = side;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, this.side);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SidedBlockCoord other = (SidedBlockCoord)obj;
            return other.x == this.x && other.y == this.y && other.z == this.z && other.side == this.side;
        }
    }
}

