/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.tile;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.vec.Cuboid6;
import com.bluepowermod.api.misc.IScrewdriver;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import moe.nightfall.vic.integratedcircuits.Constants;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GateIO;
import moe.nightfall.vic.integratedcircuits.gate.Socket;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.tile.TileEntitySocket;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSocket
extends BlockContainer {
    public BlockSocket() {
        super(Material.field_151594_q);
        this.func_149663_c("integratedcircuits.gate");
        this.func_149711_c(1.0f);
        Socket.box.setBlockBounds((Block)this);
    }

    public Item func_149650_a(int par1, Random rand, int par3) {
        return Content.itemSocket;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        ItemStack stack = te.getSocket().pickItem(target);
        return stack != null ? stack : new ItemStack(Content.itemSocket);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return !world.field_72995_K && ((TileEntitySocket)world.func_147438_o(x, y, z)).getSocket().rotate();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        Cuboid6 bounds = Socket.box.copy().apply(Socket.getRotationTransformation(te.getSocket()));
        bounds.setBlockBounds((Block)this);
    }

    public AxisAlignedBB getStatelessBoundingBox(World world, int x, int y, int z) {
        return null;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return this.getStatelessBoundingBox(world, x, y, z);
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        te.getSocket().scheduledTick();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        if (!te.isDestroyed) {
            te.getSocket().onNeighborChanged();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item item;
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        ItemStack heldStack = player.func_70694_bm();
        if (heldStack != null && Socket.checkItemIsTool(item = heldStack.func_77973_b()) && !player.func_70093_af() && (IntegratedCircuits.isBPAPIThere && item instanceof IScrewdriver || IntegratedCircuits.isBCToolsAPIThere && item instanceof IToolWrench)) {
            return false;
        }
        return te.getSocket().activate(player, new MovingObjectPosition(x, y, z, side, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ)), heldStack);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        ArrayList drops = Lists.newArrayList();
        te.getSocket().addDrops(drops);
        for (ItemStack stack : drops) {
            MiscUtils.dropItem(world, stack, x, y, z);
        }
        te.getSocket().onRemoved();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return Constants.GATE_RENDER_ID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySocket();
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntitySocket te;
        ISocket socket;
        if (((side = GateIO.vanillaToSide(side)) & 6) == ((socket = (te = (TileEntitySocket)world.func_147438_o(x, y, z)).getSocket()).getSide() & 6)) {
            return false;
        }
        int rel = socket.getSideRel(side);
        return socket.getConnectionTypeAtSide(rel).isRedstone();
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149748_c(world, x, y, z, side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntitySocket te = (TileEntitySocket)world.func_147438_o(x, y, z);
        ISocket socket = te.getSocket();
        if (((side ^= 1) & 6) == (socket.getSide() & 6)) {
            return 0;
        }
        int rot = socket.getSideRel(side);
        if (!socket.getConnectionTypeAtSide(side).isRedstone()) {
            return 0;
        }
        return socket.getRedstoneOutput(rot);
    }
}

