/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.MultipartHelper;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketWrapper;
import moe.nightfall.vic.integratedcircuits.compat.BPDevice;
import moe.nightfall.vic.integratedcircuits.gate.Socket;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FMPartSocket
extends JCuboidPart
implements JNormalOcclusion,
TFacePart,
IFaceRedstonePart,
ISocketWrapper {
    private ISocket socket = IntegratedCircuitsAPI.getGateRegistry().createSocketInstance(this);
    private BPDevice bpDevice;

    public String getType() {
        return "integratedcircuits.socket_fmp";
    }

    public void load(NBTTagCompound tag) {
        this.socket.readFromNBT(tag);
    }

    public void save(NBTTagCompound tag) {
        this.socket.writeToNBT(tag);
    }

    public void readDesc(MCDataInput packet) {
        this.socket.readDesc(packet.readNBTTagCompound());
    }

    public void writeDesc(MCDataOutput packet) {
        NBTTagCompound compound = new NBTTagCompound();
        this.socket.writeDesc(compound);
        packet.writeNBTTagCompound(compound);
    }

    public void read(MCDataInput packet) {
        this.socket.read(packet);
    }

    @Override
    public MCDataOutput getWriteStream(int disc) {
        return this.getWriteStream().writeByte(disc);
    }

    public Cuboid6 getBounds() {
        return Socket.box.copy().apply(Socket.getRotationTransformation(this.socket));
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public int getSlotMask() {
        return 1 << this.socket.getSide();
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public void update() {
        this.socket.update();
    }

    public void scheduledTick() {
        this.socket.scheduledTick();
    }

    public boolean solid(int arg0) {
        return false;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        return this.socket.activate(player, hit, item);
    }

    public void onAdded() {
        this.socket.onAdded();
    }

    public void onRemoved() {
        this.socket.onRemoved();
    }

    public void onMoved() {
        this.socket.onMoved();
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList list = Lists.newArrayList();
        this.socket.addDrops(list);
        list.add(new ItemStack(Content.itemSocketFMP));
        return list;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        ItemStack stack = this.socket.pickItem(hit);
        if (stack == null) {
            stack = new ItemStack(Content.itemSocketFMP);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0) {
            CCRenderState.setBrightness((IBlockAccess)this.getWorld(), (int)this.x(), (int)this.y(), (int)this.z());
            ClientProxy.socketRendererFMP.prepare(this.socket);
            ClientProxy.socketRendererFMP.renderStatic((Transformation)new Translation(pos));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            TextureUtils.bindAtlas((int)0);
            ClientProxy.socketRendererFMP.prepareDynamic(this.socket, frame);
            ClientProxy.socketRendererFMP.renderDynamic((Transformation)new Translation(pos));
        }
    }

    public void onNeighborChanged() {
        this.socket.onNeighborChanged();
    }

    public void onPartChanged(TMultiPart part) {
        this.socket.onNeighborChanged();
    }

    public final boolean canConnectRedstone(int arg0) {
        if ((arg0 & 6) == (this.socket.getSide() & 6)) {
            return false;
        }
        return this.socket.getConnectionTypeAtSide(this.socket.getSideRel(arg0)).isRedstone();
    }

    public int strongPowerLevel(int arg0) {
        if ((arg0 & 6) == (this.socket.getSide() & 6)) {
            return 0;
        }
        int rot = this.socket.getSideRel(arg0);
        ISocket.EnumConnectionType type = this.socket.getConnectionTypeAtSide(rot);
        if (type.isBundled()) {
            return 0;
        }
        return this.socket.getRedstoneOutput(rot);
    }

    public int weakPowerLevel(int arg0) {
        return this.strongPowerLevel(arg0);
    }

    public int getFace() {
        return this.socket.getSide();
    }

    @Override
    public void markRender() {
        if (this.tile() != null) {
            this.tile().markRender();
        }
    }

    @Override
    public World getWorld() {
        return this.world();
    }

    @Override
    public void notifyPartChange() {
        this.tile().notifyPartChange((TMultiPart)this);
    }

    @Override
    public void notifyBlocksAndChanges() {
        this.tile().func_70296_d();
        this.tile().notifyNeighborChange(this.socket.getSide());
    }

    @Override
    public BlockCoord getPos() {
        return new BlockCoord(this.x(), this.y(), this.z());
    }

    @Override
    public void destroy() {
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public byte[] updateBundledInput(int side) {
        return IntegratedCircuitsAPI.updateBundledInput(this.getSocket(), side);
    }

    @Override
    public int updateRedstoneInput(int side) {
        IRedstonePart rp;
        int rotation = this.socket.getRotationAbs(side);
        int face = this.socket.getSide();
        int abs = Rotation.rotateSide((int)face, (int)rotation);
        int power = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)abs);
        if (power != 0) {
            return power;
        }
        TMultiPart tp = ((TileMultipart)((FMPartSocket)this.socket.getWrapper()).getTile()).partMap(abs);
        if (tp instanceof IRedstonePart && (power = Math.max((rp = (IRedstonePart)tp).strongPowerLevel(face), rp.weakPowerLevel(face)) << 4) != 0) {
            return power;
        }
        return IntegratedCircuitsAPI.updateRedstoneInput(this.getSocket(), side);
    }

    @Override
    public void sendDescription() {
        MultipartHelper.sendDescPacket((World)this.getWorld(), (TileEntity)this.getTile());
    }

    @Override
    public ISocket getSocket() {
        return this.socket;
    }

    @Override
    public void updateInput() {
        this.socket.updateInput();
    }
}

