/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.tile;

import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.DiskDrive;
import moe.nightfall.vic.integratedcircuits.LaserHelper;
import moe.nightfall.vic.integratedcircuits.client.TextureRenderer;
import moe.nightfall.vic.integratedcircuits.client.TileEntityAssemblerRenderer;
import moe.nightfall.vic.integratedcircuits.client.gui.GuiAssembler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.misc.CraftingSupply;
import moe.nightfall.vic.integratedcircuits.misc.IOptionsProvider;
import moe.nightfall.vic.integratedcircuits.misc.InventoryUtils;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerChangeItem;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerStart;
import moe.nightfall.vic.integratedcircuits.net.PacketFloppyDisk;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tiles.IControllable", modid="BuildCraft|Core"), @Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraft|Core")})
public class TileEntityAssembler
extends TileEntityContainer
implements DiskDrive.IDiskDrive,
ISidedInventory,
IOptionsProvider,
IHasWork,
IControllable {
    public static final int IDLE = 0;
    public static final int RUNNING = 1;
    public static final int OUT_OF_MATERIALS = 2;
    public static final int OUT_OF_PCB = 3;
    public static final int SETTING_PULL = 0;
    public static final int SETTING_REDSTONE = 1;
    public static final int RS_ENABLED = 0;
    public static final int RS_INVERTED = 1;
    public static final int RS_DISABLED = 2;
    private static final ItemStack STACK_PCB = new ItemStack(Content.itemPCB, 1);
    public int[][] refMatrix;
    private int statusCode;
    public TextureRenderer.Entry texture;
    public boolean isOccupied;
    public byte request = 1;
    private byte queue;
    private byte position;
    public int size;
    private int power = -1;
    private int output = 0;
    private boolean powerOverride;
    public boolean[][] excMatrix;
    public CircuitData cdata;
    public LaserHelper laserHelper = new LaserHelper(this, 9);
    public ItemStack[] contents = new ItemStack[13];
    public CraftingSupply craftingSupply = new CraftingSupply(this, 2, 9);
    private IOptionsProvider.OptionSet<TileEntityAssembler> optionSet = new IOptionsProvider.OptionSet<TileEntityAssembler>(this);
    private static final int[] accessibleSlots = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.texture != null) {
            TileEntityAssemblerRenderer.scheduleFramebuffer(this);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.power == -1) {
            this.onNeighborBlockChange();
        }
        if (this.refMatrix != null) {
            this.laserHelper.update();
        }
        if (this.output == 0) {
            this.func_145831_w().func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        if (this.output >= 0) {
            --this.output;
        }
        if (this.statusCode == 3 && this.queue != 0) {
            this.requestCircuitPlayload();
        } else if (this.statusCode == 0 && this.getOptionSet().getBoolean(0) && (this.isPowered() || this.powerOverride) && this.output < 0) {
            ItemStack stack = this.tryFetchPCB();
            if (stack != null) {
                this.func_70299_a(1, stack);
            }
            this.requestCircuit((byte)1);
        }
    }

    private boolean isPowered() {
        int rs = this.getOptionSet().getInt(1);
        return rs == 0 && this.power > 0 || rs == 1 && this.power == 0;
    }

    public int isProvidingPower() {
        return this.output > 0 && this.getOptionSet().getInt(1) != 2 ? 15 : 0;
    }

    public void onNeighborBlockChange() {
        int nPower = this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (nPower != this.power) {
            boolean o = this.power > 0;
            boolean n = nPower > 0;
            int rsmode = this.getOptionSet().getInt(1);
            if (o != n && (n && rsmode == 0 || !n && rsmode == 1) && this.output < 0 && this.getStatus() == 0) {
                ItemStack stack = this.tryFetchPCB();
                if (stack != null) {
                    this.func_70299_a(1, stack);
                }
                this.requestCircuit((byte)1);
            }
            this.power = nPower;
        }
    }

    public void updateStatus(int status) {
        if (this.statusCode != status) {
            this.statusCode = status;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, status);
            }
        }
    }

    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public IOptionsProvider.OptionSet getOptionSet() {
        return this.optionSet;
    }

    @Override
    public void onSettingChanged(int setting) {
        if (this.field_145850_b.field_72995_K && Minecraft.func_71410_x().field_71462_r instanceof GuiAssembler) {
            ((GuiAssembler)Minecraft.func_71410_x().field_71462_r).refreshUI();
        }
    }

    @Override
    public boolean func_145842_c(int id, int par) {
        if (id == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.statusCode = par;
            }
            return true;
        }
        if (id == 2) {
            if (this.field_145850_b.field_72995_K) {
                this.position = (byte)par;
            }
            return true;
        }
        return super.func_145842_c(id, par);
    }

    public void requestCircuit(byte amount) {
        if (this.queue != 0) {
            return;
        }
        this.setQueueSize(amount);
        if (!this.requestCircuitPlayload()) {
            this.setQueueSize((byte)0);
        }
        this.position = 0;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, (int)this.position);
    }

    private boolean requestCircuitPlayload() {
        if (this.cdata != null && this.laserHelper.getLaserAmount() > 0) {
            this.craftingSupply.clear();
            if (!(InventoryUtils.tryFetchItem(this, STACK_PCB.func_77946_l(), 1, 1) != null || this.optionSet.getBoolean(0) && this.tryFetchPCB() != null)) {
                this.updateStatus(3);
                return true;
            }
            this.laserHelper.reset();
            this.laserHelper.start();
            this.updateStatus(1);
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerStart(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.queue), this.field_145850_b.field_73011_w.field_76574_g);
            return true;
        }
        return false;
    }

    public ItemStack tryFetchPCB() {
        ItemStack pcb = this.func_70301_a(1);
        if (pcb != null) {
            if (STACK_PCB.func_77969_a(pcb)) {
                return pcb;
            }
            if (!InventoryUtils.tryPutItem(this, pcb, 2, 9)) {
                return null;
            }
            this.func_70299_a(1, null);
        }
        pcb = InventoryUtils.tryFetchItem(this, STACK_PCB.func_77946_l(), 2, 9);
        return pcb;
    }

    public void setQueueSize(byte queue) {
        this.queue = queue;
    }

    public byte getQueueSize() {
        return this.queue;
    }

    public void clearQueue() {
        this.position = 0;
        this.queue = 0;
        if (this.getStatus() != 1 && this.getStatus() != 2) {
            this.laserHelper.reset();
            this.updateStatus(0);
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerStart(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.queue), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    public byte getQueuePosition() {
        return this.position;
    }

    public void onCircuitFinished() {
        if (this.func_70301_a(1) == null) {
            this.contents[1] = new ItemStack(Content.itemPCB, 1, 1);
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74782_a("circuit", (NBTBase)this.cdata.writeToNBTRaw(new NBTTagCompound()));
            this.contents[1].func_77982_d(comp);
            this.position = (byte)(this.position + 1);
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, (int)this.position);
            this.output = 2;
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        if (this.position == this.queue || this.queue == 0) {
            this.queue = 0;
            this.updateStatus(0);
        } else {
            this.requestCircuitPlayload();
        }
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K && this.texture != null) {
            ClientProxy.textureRenderer.delete(this.texture);
            this.texture = null;
        }
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public ItemStack func_70301_a(int id) {
        return this.contents[id];
    }

    @Override
    public ItemStack func_70298_a(int id, int amount) {
        ItemStack temp = this.func_70301_a(id);
        ItemStack stack = null;
        if (this.contents[id] != null) {
            if (this.contents[id].field_77994_a <= amount) {
                stack = this.contents[id];
                this.contents[id] = null;
            } else {
                stack = this.contents[id].func_77979_a(amount);
                if (this.contents[id].field_77994_a == 0) {
                    this.contents[id] = null;
                }
            }
            this.func_70296_d();
        }
        if (!ItemStack.func_77989_b((ItemStack)temp, (ItemStack)this.contents[id])) {
            this.onSlotChange(id);
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int id) {
        return this.func_70301_a(id);
    }

    public void func_70299_a(int id, ItemStack stack) {
        boolean change = !ItemStack.func_77989_b((ItemStack)this.contents[id], (ItemStack)stack);
        this.contents[id] = stack;
        if (change) {
            this.onSlotChange(id);
        }
        this.func_70296_d();
    }

    @Override
    public void onSlotChange(int id) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (id > 8 && id < 13) {
            this.laserHelper.createLaser(id - 9, this.func_70301_a(id));
        } else if (id == 1) {
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerChangeItem(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_70301_a(id) != null), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    @Override
    public String func_145825_b() {
        return null;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return MiscUtils.getRotatedInstance(AxisAlignedBB.func_72330_a((double)0.0625, (double)0.0625, (double)-0.0625, (double)0.8125, (double)0.1875, (double)0.0625), this.rotation);
    }

    @Override
    public ItemStack getDisk() {
        return this.func_70301_a(0);
    }

    public void dropContents() {
        for (ItemStack stack : this.contents) {
            if (stack == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, stack));
        }
    }

    @Override
    public void setDisk(ItemStack stack) {
        this.func_70299_a(0, stack);
        if (!this.field_145850_b.field_72995_K) {
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketFloppyDisk(this.field_145851_c, this.field_145848_d, this.field_145849_e, stack), this.field_145850_b.field_73011_w.field_76574_g);
        }
        this.loadMatrixFromDisk();
        if (this.field_145850_b.field_72995_K && Minecraft.func_71410_x().field_71462_r instanceof GuiCAD) {
            this.cdata.calculateCost();
            ((GuiAssembler)Minecraft.func_71410_x().field_71462_r).refreshUI();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList slotList = compound.func_150295_c("contents", 10);
        for (int i = 0; i < 13; ++i) {
            this.contents[i] = slotList.func_150305_b(i).func_82582_d() ? null : ItemStack.func_77949_a((NBTTagCompound)slotList.func_150305_b(i));
        }
        this.powerOverride = compound.func_74767_n("powerOverride");
        this.output = compound.func_74762_e("output");
        this.queue = compound.func_74771_c("queue");
        this.position = compound.func_74771_c("positon");
        this.statusCode = compound.func_74762_e("status");
        this.optionSet = IOptionsProvider.OptionSet.readFromNBT(compound, this);
        this.loadMatrix(compound);
        if (compound.func_74764_b("tmp")) {
            this.excMatrix = new boolean[this.size][this.size];
            byte[] temp = compound.func_74770_j("tmp");
            for (int i = 0; i < temp.length; ++i) {
                this.excMatrix[i / this.size][i % this.size] = temp[i] != 0;
            }
        }
        this.laserHelper.readFromNBT(compound);
        if (MiscUtils.isClient() && (this.func_70301_a(1) != null || this.laserHelper.isRunning)) {
            this.isOccupied = true;
            TileEntityAssemblerRenderer.scheduleFramebuffer(this);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList slotList = new NBTTagList();
        for (int i = 0; i < 13; ++i) {
            slotList.func_74742_a((NBTBase)(this.contents[i] != null ? this.contents[i].func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
        }
        compound.func_74782_a("contents", (NBTBase)slotList);
        compound.func_74757_a("powerOverride", this.powerOverride);
        compound.func_74768_a("output", this.output);
        compound.func_74774_a("queue", this.queue);
        compound.func_74774_a("positon", this.position);
        compound.func_74768_a("status", this.statusCode);
        this.optionSet.writeToNBT(compound);
        this.saveMatrix(compound);
        if (this.excMatrix != null) {
            byte[] temp = new byte[this.size * this.size];
            for (int x = 0; x < this.size; ++x) {
                for (int y = 0; y < this.size; ++y) {
                    temp[x + y * this.size] = (byte)(this.excMatrix[x][y] ? 1 : 0);
                }
            }
            compound.func_74773_a("tmp", temp);
        }
        this.laserHelper.writeToNBT(compound);
    }

    private void loadMatrix(NBTTagCompound compound) {
        if (compound.func_74764_b("circuit")) {
            NBTTagCompound circuit = compound.func_74775_l("circuit");
            this.cdata = CircuitData.readFromNBT(circuit);
            this.craftingSupply = CraftingSupply.readFromNBT(compound, this, 2, 9);
            this.size = this.cdata.getSize();
            this.refMatrix = new int[this.size][this.size];
            NBTTagList idlist = circuit.func_150295_c("id", 11);
            for (int i = 0; i < idlist.func_74745_c(); ++i) {
                this.refMatrix[i] = idlist.func_150306_c(i);
            }
        }
    }

    private void saveMatrix(NBTTagCompound compound) {
        if (this.refMatrix != null) {
            NBTTagCompound circuit = new NBTTagCompound();
            this.cdata.writeToNBTRaw(circuit);
            this.craftingSupply.writeToNBT(compound);
            compound.func_74782_a("circuit", (NBTBase)circuit);
        }
    }

    public void loadMatrixFromDisk() {
        if (this.getDisk() != null) {
            ItemStack stack = this.getDisk();
            NBTTagCompound comp = stack.func_77978_p();
            if (comp != null && comp.func_74764_b("circuit")) {
                this.loadMatrix(comp);
            } else {
                this.refMatrix = null;
            }
        }
    }

    public int[] func_94128_d(int side) {
        if (this.getConnectionOnSide(side) > -1) {
            return accessibleSlots;
        }
        return new int[0];
    }

    private int getConnectionOnSide(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (dir == ForgeDirection.UP) {
            return -1;
        }
        if (dir == ForgeDirection.DOWN) {
            return 0;
        }
        dir = MiscUtils.rotn(ForgeDirection.getOrientation((int)side), -this.rotation);
        if (dir == ForgeDirection.SOUTH) {
            return 1;
        }
        if (dir != ForgeDirection.NORTH) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean func_94041_b(int id, ItemStack stack) {
        if (id < 1 || id > 9) {
            return false;
        }
        if (id == 1 && this.func_70301_a(1) == null && STACK_PCB.func_77969_a(stack)) {
            return true;
        }
        return id != 1;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        int con = this.getConnectionOnSide(side);
        return con == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        boolean isPCB;
        int con = this.getConnectionOnSide(side);
        boolean bl = isPCB = stack.func_77973_b() == Content.itemPCB && stack.func_77960_j() == 1;
        if (con == 0) {
            return slot != 1 && !isPCB;
        }
        if (con == 1) {
            return isPCB;
        }
        return false;
    }

    public IControllable.Mode getControlMode() {
        if (this.powerOverride || this.isPowered()) {
            return IControllable.Mode.On;
        }
        return IControllable.Mode.Off;
    }

    public void setControlMode(IControllable.Mode mode) {
        if (mode == IControllable.Mode.On) {
            this.powerOverride = true;
            this.getOptionSet().changeSetting(0, true);
        } else if (mode == IControllable.Mode.Off) {
            this.powerOverride = false;
        }
    }

    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    public boolean hasWork() {
        return this.getStatus() != 0;
    }

    @Override
    public boolean rotate() {
        this.rotation = this.rotation + 1 & 3;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }
}

