/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.tile;

import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.DiskDrive;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.cp.CircuitCache;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.net.PacketFloppyDisk;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangeInput;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBSimulation;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBUpdate;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCAD
extends TileEntityContainer
implements ICircuit,
DiskDrive.IDiskDrive {
    private ItemStack floppyStack;
    private CircuitData circuitData;
    public CircuitCache cache = new CircuitCache(this);
    public float scale = 0.33f;
    public double offX = 0.0;
    public double offY = 0.0;
    public int[] in = new int[4];
    public int[] out = new int[4];
    private boolean updateIO;
    private boolean pausing = false;
    private boolean step = false;
    private ForgeDirection printerLocation;

    public boolean isPausing() {
        return this.pausing;
    }

    public void setPausing(boolean pausing) {
        this.pausing = pausing;
        this.step = false;
    }

    public void step() {
        this.step = true;
    }

    public void sendSimulationState() {
        CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBSimulation(this.step, this.pausing, this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public void setup(int size) {
        this.circuitData = new CircuitData(size, this);
        this.circuitData.clearAllAndSetup(size);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.playersUsing > 0) {
            if (this.step || !this.pausing) {
                this.getCircuitData().updateMatrix();
                this.step = false;
            }
            if (this.getCircuitData().checkUpdate()) {
                CommonProxy.networkWrapper.sendToAllAround((IMessage)new PacketPCBUpdate(this.getCircuitData(), this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 8.0));
            }
            if (this.updateIO) {
                this.updateIO = false;
                CommonProxy.networkWrapper.sendToAllAround((IMessage)new PacketPCBChangeInput(false, this.out, this.circuitData.getProperties().getCon(), this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 8.0));
            }
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.circuitData = CircuitData.readFromNBT(compound.func_74775_l("circuit"), this);
        this.in = compound.func_74759_k("in");
        this.out = compound.func_74759_k("out");
        this.pausing = compound.func_74767_n("pausing");
        NBTTagCompound stackCompound = compound.func_74775_l("floppyStack");
        this.floppyStack = ItemStack.func_77949_a((NBTTagCompound)stackCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74782_a("circuit", (NBTBase)this.circuitData.writeToNBT(new NBTTagCompound()));
        compound.func_74783_a("in", this.in);
        compound.func_74783_a("out", this.out);
        compound.func_74757_a("pausing", this.pausing);
        NBTTagCompound stackCompound = new NBTTagCompound();
        if (this.floppyStack != null) {
            this.floppyStack.func_77955_b(stackCompound);
        }
        compound.func_74782_a("floppyStack", (NBTBase)stackCompound);
    }

    public final boolean getExternalInputFromSide(ForgeDirection dir, int frequency) {
        return (this.in[MiscUtils.getSide(dir)] & 1 << frequency) != 0;
    }

    @Override
    public boolean getInputFromSide(ForgeDirection dir, int frequency) {
        return this.getExternalInputFromSide(dir, frequency) && !this.getOutputToSide(dir, frequency);
    }

    public boolean getOutputToSide(ForgeDirection dir, int frequency) {
        return (this.out[MiscUtils.getSide(dir)] & 1 << frequency) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setExternalInputFromSide(ForgeDirection dir, int frequency, boolean output) {
        ISocket.EnumConnectionType mode = this.circuitData.getProperties().getModeAtSide(MiscUtils.getSide(dir));
        if (mode != ISocket.EnumConnectionType.SIMPLE || frequency == 0) {
            int[] i = (int[])this.in.clone();
            if (mode == ISocket.EnumConnectionType.ANALOG) {
                i[MiscUtils.getSide((ForgeDirection)dir)] = 0;
            }
            if (output) {
                int n = MiscUtils.getSide(dir);
                i[n] = i[n] | 1 << frequency;
            } else if (mode == ISocket.EnumConnectionType.ANALOG) {
                i[MiscUtils.getSide((ForgeDirection)dir)] = 1;
            } else {
                int n = MiscUtils.getSide(dir);
                i[n] = i[n] & ~(1 << frequency);
            }
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangeInput(true, i, this.circuitData.getProperties().getCon(), this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setInputMode(int side, ISocket.EnumConnectionType mode) {
        int con = this.circuitData.getProperties().setModeAtSide(side, mode);
        int[] i = (int[])this.in.clone();
        i[side] = mode == ISocket.EnumConnectionType.ANALOG ? 1 : 0;
        CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangeInput(true, i, con, this));
    }

    @Override
    public void setOutputToSide(ForgeDirection dir, int frequency, boolean output) {
        if (output) {
            int n = MiscUtils.getSide(dir);
            this.out[n] = this.out[n] | 1 << frequency;
        } else {
            int n = MiscUtils.getSide(dir);
            this.out[n] = this.out[n] & ~(1 << frequency);
        }
        this.updateIO = true;
    }

    @Override
    public boolean func_145842_c(int id, int par) {
        if (id == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.printerLocation = ForgeDirection.getOrientation((int)par);
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (gui instanceof GuiCAD) {
                    ((GuiCAD)gui).refreshPrinter();
                }
            }
            return true;
        }
        return super.func_145842_c(id, par);
    }

    public void onNeighborBlockChange() {
        BlockCoord bc = new BlockCoord((TileEntity)this);
        ForgeDirection oldPrinterLocation = this.printerLocation;
        this.printerLocation = ForgeDirection.UNKNOWN;
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord bcs = bc.offset(fd.ordinal());
            if (this.field_145850_b.func_147439_a(bcs.x, bcs.y, bcs.z) != Content.blockPrinter) continue;
            this.printerLocation = fd;
        }
        if (!this.field_145850_b.field_72995_K && oldPrinterLocation != this.printerLocation) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.printerLocation.ordinal());
        }
    }

    public ForgeDirection printerLocation() {
        if (this.printerLocation == null) {
            this.onNeighborBlockChange();
        }
        return this.printerLocation;
    }

    public boolean isPrinterConnected() {
        return this.printerLocation() != ForgeDirection.UNKNOWN;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int id) {
        return id == 0 ? this.floppyStack : null;
    }

    public void func_70299_a(int id, ItemStack stack) {
        if (id == 0) {
            this.floppyStack = stack;
        }
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int id, ItemStack stack) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return MiscUtils.getRotatedInstance(AxisAlignedBB.func_72330_a((double)0.0625, (double)0.0625, (double)-0.0625, (double)0.8125, (double)0.1875, (double)0.0625), this.rotation);
    }

    @Override
    public ItemStack getDisk() {
        return this.func_70301_a(0);
    }

    @Override
    public void setDisk(ItemStack stack) {
        this.func_70299_a(0, stack);
        if (!this.field_145850_b.field_72995_K) {
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketFloppyDisk(this.field_145851_c, this.field_145848_d, this.field_145849_e, stack), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    @Override
    public CircuitData getCircuitData() {
        return this.circuitData;
    }

    @Override
    public void setCircuitData(CircuitData data) {
        this.circuitData = data;
    }
}

