/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.minecraft2discord;

import java.util.List;
import java.util.stream.Collectors;
import ml.denis3d.minecraft2discord.Config;
import ml.denis3d.minecraft2discord.DiscordCommandSource;
import ml.denis3d.minecraft2discord.Minecraft2Discord;
import ml.denis3d.minecraft2discord.Utils;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ISnowflake;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Webhook;
import ml.denis3d.repack.net.dv8tion.jda.core.events.ReadyEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.hooks.ListenerAdapter;
import ml.denis3d.repack.net.dv8tion.jda.webhook.WebhookClient;
import ml.denis3d.repack.net.dv8tion.jda.webhook.WebhookMessageBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class BotEvents
extends ListenerAdapter {
    private static Webhook discordWebhook;
    private static WebhookClient discordWebhookClient;
    private static WebhookMessageBuilder builder;
    private static TextChannel chatChannel;
    private static TextChannel infoChannel;

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        if (Minecraft2Discord.getDiscordBot() == null) {
            return;
        }
        if (chatChannel == null) {
            chatChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.chatChannel.get());
        }
        if (chatChannel != null && (Long)Config.SERVER.chatChannel.get() != 0L) {
            if (((Boolean)Config.SERVER.useDiscordWebhooks.get()).booleanValue()) {
                if (discordWebhookClient == null) {
                    if (discordWebhook == null) {
                        List discordWebhooks = chatChannel.getWebhooks().complete().stream().filter(webhook -> webhook.getName().startsWith("Minecraft2Discord")).collect(Collectors.toList());
                        discordWebhook = discordWebhooks.size() == 0 ? (Webhook)chatChannel.createWebhook("Minecraft2Discord").complete() : (Webhook)discordWebhooks.get(0);
                    }
                    discordWebhookClient = discordWebhook.newClient().build();
                }
                builder = new WebhookMessageBuilder();
                builder.setContent(event.getMessage()).setUsername(event.getUsername()).setAvatarUrl(Utils.globalVariableReplacement((String)Config.SERVER.discordPictureAPI.get()).replace("$1", event.getUsername()).replace("$2", event.getPlayer().func_110124_au().toString()));
                discordWebhookClient.send(builder.build());
            } else {
                chatChannel.sendMessage("**" + event.getUsername() + "** : " + event.getMessage()).submit();
            }
        }
        Utils.updateDiscordPresence();
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && ((Boolean)Config.SERVER.sendDeathsMessages.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
            if (Minecraft2Discord.getDiscordBot() == null) {
                return;
            }
            if (infoChannel == null) {
                infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
            }
            if (infoChannel != null) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                infoChannel.sendMessage(Utils.globalVariableReplacement((String)Config.SERVER.deathMessage.get()).replace("$1", player.func_200200_C_().func_150261_e()).replace("$2", player.func_110142_aN().func_151521_b().func_150261_e())).submit();
            }
        }
        Utils.updateDiscordPresence();
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getAdvancement().func_192067_g().func_110623_a().startsWith("recipes")) {
            if (((List)Config.SERVER.hideAdvancementList.get()).stream().anyMatch(s -> s.startsWith(event.getAdvancement().func_192067_g().toString()))) {
                return;
            }
            if (((Boolean)Config.SERVER.sendAdvancementMessages.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
                if (Minecraft2Discord.getDiscordBot() == null) {
                    return;
                }
                if (infoChannel == null) {
                    infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
                }
                if (infoChannel != null) {
                    PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                    String message = Utils.globalVariableReplacement((String)Config.SERVER.advancementMessage.get());
                    message = message.replace("$1", player.func_200200_C_().func_150261_e());
                    message = message.replace("$2", event.getAdvancement().func_193123_j().getString());
                    message = event.getAdvancement().func_192068_c() != null ? message.replace("$3", event.getAdvancement().func_192068_c().func_193222_b().func_150261_e()) : message.replace("$3", "");
                    infoChannel.sendMessage(message).submit();
                }
            }
        }
        Utils.updateDiscordPresence();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)Config.SERVER.sendJoinLeftMessages.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
            if (Minecraft2Discord.getDiscordBot() == null) {
                return;
            }
            if (infoChannel == null) {
                infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
            }
            if (infoChannel != null) {
                infoChannel.sendMessage(Utils.globalVariableReplacement((String)Config.SERVER.joinMessage.get()).replace("$1", event.getPlayer().func_200200_C_().func_150261_e())).submit();
            }
        }
        Utils.updateDiscordPresence();
    }

    @SubscribeEvent
    public static void onPlayerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        if (((Boolean)Config.SERVER.sendJoinLeftMessages.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
            if (Minecraft2Discord.getDiscordBot() == null) {
                return;
            }
            if (infoChannel == null) {
                infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
            }
            if (infoChannel != null) {
                infoChannel.sendMessage(Utils.globalVariableReplacement((String)Config.SERVER.leftMessage.get()).replace("$1", event.getPlayer().func_200200_C_().func_150261_e())).submit();
            }
        }
        Utils.updateDiscordPresence();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        InterModComms.getMessages((String)"minecraft2discord").forEach(imcMessage -> {
            if (imcMessage.getMethod().equals("info_channel") && ((Boolean)Config.SERVER.allowInterModComms.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
                if (Minecraft2Discord.getDiscordBot() == null) {
                    return;
                }
                if (infoChannel == null) {
                    infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
                }
                if (infoChannel != null) {
                    infoChannel.sendMessage(Utils.globalVariableReplacement(imcMessage.getMessageSupplier().get().toString())).submit();
                }
            }
            if (imcMessage.getMethod().equals("chat_channel") && ((Boolean)Config.SERVER.allowInterModComms.get()).booleanValue() && (Long)Config.SERVER.chatChannel.get() != 0L) {
                if (Minecraft2Discord.getDiscordBot() == null) {
                    return;
                }
                if (chatChannel == null) {
                    chatChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.chatChannel.get());
                }
                if (chatChannel != null) {
                    chatChannel.sendMessage(Utils.globalVariableReplacement(imcMessage.getMessageSupplier().get().toString())).submit();
                }
            }
            if (imcMessage.getMethod().matches("\\d+") && ((Boolean)Config.SERVER.allowInterModComms.get()).booleanValue()) {
                if (Minecraft2Discord.getDiscordBot() == null) {
                    return;
                }
                TextChannel channel = Minecraft2Discord.getDiscordBot().getTextChannelById(imcMessage.getMethod());
                if (channel != null) {
                    channel.sendMessage(Utils.globalVariableReplacement(imcMessage.getMessageSupplier().get().toString())).submit();
                }
            }
        });
    }

    @Override
    public void onReady(ReadyEvent event) {
        System.out.println("Discord bot logged as " + event.getJDA().getSelfUser().getName());
        if (((Boolean)Config.SERVER.sendServerStartStopMessages.get()).booleanValue() && (Long)Config.SERVER.infoChannel.get() != 0L) {
            if (infoChannel == null) {
                infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
            }
            if (infoChannel != null) {
                infoChannel.sendMessage(Utils.globalVariableReplacement((String)Config.SERVER.serverStartMessage.get())).submit();
            }
        }
        Utils.updateDiscordPresence();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        block3: {
            block4: {
                block5: {
                    if (((Long)Config.SERVER.chatChannel.get()).longValue() != event.getChannel().getIdLong() || event.getAuthor().isBot()) break block3;
                    if (!event.getMessage().getContentRaw().startsWith("/")) break block4;
                    if (((List)Config.SERVER.commandAllowedUsersIds.get()).contains(event.getAuthor().getIdLong())) break block5;
                    if (!event.getMember().getRoles().stream().map(ISnowflake::getIdLong).anyMatch(((List)Config.SERVER.commandAllowedRolesIds.get())::contains)) break block4;
                }
                ServerLifecycleHooks.getCurrentServer().func_195571_aL().func_197059_a(new CommandSource((ICommandSource)new DiscordCommandSource(event.getChannel()), ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_) == null ? Vec3d.field_186680_a : new Vec3d((Vec3i)ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_175694_M()), Vec2f.field_189974_a, ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_), 4, "Discord", (ITextComponent)new StringTextComponent("Discord"), ServerLifecycleHooks.getCurrentServer(), null), event.getMessage().getContentDisplay());
                if (event.getMessage().getContentRaw().startsWith("/say") && (Long)Config.SERVER.infoChannel.get() != 0L) {
                    if (infoChannel == null) {
                        infoChannel = Minecraft2Discord.getDiscordBot().getTextChannelById((Long)Config.SERVER.infoChannel.get());
                    }
                    if (infoChannel != null) {
                        infoChannel.sendMessage(Utils.globalVariableReplacement(event.getMessage().getContentRaw().substring(5))).submit();
                    }
                }
                break block3;
            }
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148539_a((ITextComponent)new StringTextComponent("<Discord - " + event.getAuthor().getName() + "> " + event.getMessage().getContentDisplay()));
        }
        Utils.updateDiscordPresence();
    }
}

