/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.minecraft2discord;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec SERVER_SPECS;
    public static final Server SERVER;

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPECS = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<String> botToken;
        public final ForgeConfigSpec.ConfigValue<List<? extends Long>> commandAllowedUsersIds;
        public final ForgeConfigSpec.ConfigValue<List<? extends Long>> commandAllowedRolesIds;
        public final ForgeConfigSpec.LongValue chatChannel;
        public final ForgeConfigSpec.LongValue infoChannel;
        public final ForgeConfigSpec.BooleanValue sendJoinLeftMessages;
        public final ForgeConfigSpec.BooleanValue sendAdvancementMessages;
        public final ForgeConfigSpec.BooleanValue sendDeathsMessages;
        public final ForgeConfigSpec.BooleanValue sendServerStartStopMessages;
        public final ForgeConfigSpec.BooleanValue discordCommandEnabled;
        public final ForgeConfigSpec.BooleanValue enableDiscordPresence;
        public final ForgeConfigSpec.BooleanValue useDiscordWebhooks;
        public final ForgeConfigSpec.ConfigValue<String> joinMessage;
        public final ForgeConfigSpec.ConfigValue<String> leftMessage;
        public final ForgeConfigSpec.ConfigValue<String> advancementMessage;
        public final ForgeConfigSpec.ConfigValue<String> deathMessage;
        public final ForgeConfigSpec.ConfigValue<String> serverStartMessage;
        public final ForgeConfigSpec.ConfigValue<String> serverStopMessage;
        public final ForgeConfigSpec.ConfigValue<String> discordPresence;
        public final ForgeConfigSpec.ConfigValue<String> discordInviteLink;
        public final ForgeConfigSpec.ConfigValue<String> discordPictureAPI;
        public final ForgeConfigSpec.BooleanValue allowInterModComms;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hideAdvancementList;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment(" Config for data coming from your discord server").push("Discord");
            this.botToken = builder.comment(" Token for your Discord bot. Look at curseforge project one if you don't know how to get one").define("botToken", (Object)"");
            this.commandAllowedUsersIds = builder.comment(" List of the members who is allowed to use command from discord (include op and no-op command)").defineList("commandAllowedUsersIds", ArrayList::new, e -> e instanceof Long);
            this.commandAllowedRolesIds = builder.comment(" List of the roles who is allowed to use command from discord (include op and no-op command)").defineList("commandAllowedRolesIds", ArrayList::new, e -> e instanceof Long);
            builder.comment(" Discord Channels Ids").push("Channels");
            this.chatChannel = builder.comment(" Chat : All players messages").defineInRange("chat", 0L, 0L, Long.MAX_VALUE);
            this.infoChannel = builder.comment(" Info : Death, Advancement, Join / Left, Server Start/Stop...").defineInRange("info", 0L, 0L, Long.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.comment(" Toggle features on and off (Send in info channel)").push("Features");
            this.sendJoinLeftMessages = builder.comment(" Send players join/left messages.").define("sendJoinLeftMessages", true);
            this.sendAdvancementMessages = builder.comment(" Send players advancements messages.").define("sendAdvancementsMessages", true);
            this.sendDeathsMessages = builder.comment(" Send players deaths messages.").define("sendDeathsMessages", true);
            this.sendServerStartStopMessages = builder.comment(" Send server start/stop messages.").define("sendServerStartStopMessages", true);
            this.discordCommandEnabled = builder.comment(" Enable or disable the discord command that show an invite link (cf : Misc.discordInviteLink)").define("discordCommandEnabled", true);
            this.enableDiscordPresence = builder.comment(" Enable or disable discord presence of the bot (ex : Playing .......)").define("enableDiscordPresence", false);
            this.useDiscordWebhooks = builder.comment(" Enable or disable the use of webhooks (custom profile picture and name in discord). If false message will be send with the bot account in the form : player_name : message").define("useDiscordWebhooks", true);
            builder.pop();
            builder.comment(" Customise the messages here. Global variable : $online_players$, $max_players$, $motd$, $mc_version$, $server_hostname$, $server_port$").push("Messages");
            this.joinMessage = builder.comment(" $1 = player name").define("joinMessage", (Object)"$1 joined the game.");
            this.leftMessage = builder.comment(" $1 = player name").define("leftMessage", (Object)"$1 left the game.");
            this.advancementMessage = builder.comment(" $1 = player name, $2 = advancement, $3 = advancement description").define("advancementMessage", (Object)"$1 has made the advancement $2. $3");
            this.deathMessage = builder.comment(" $1 = player name, $2 = death message").define("deathMessage", (Object)"$1 $2.");
            this.serverStartMessage = builder.comment("Global variable only").define("serverStartMessage", (Object)"Server has started.");
            this.serverStopMessage = builder.comment("Global variable only").define("serverStopMessage", (Object)"Server has stopped.");
            this.discordPresence = builder.comment("Global variable only").define("discordPresence", (Object)"$online_players$ / $max_players$ players");
            builder.pop();
            builder.comment(" Some miscellaneous configuration").push("Misc");
            this.discordInviteLink = builder.comment(" Invite link for your discord server").define("discordInviteLink", (Object)"Invite link not set");
            this.discordPictureAPI = builder.comment(" API url for discord profile picture. $1 is player name and $2 is the player UUID.").define("discordPictureAPI", (Object)"https://minotar.net/avatar/$1");
            this.allowInterModComms = builder.comment(" Allow other mod to send message to discord using Minecraft2Discord").define("discordCommandEnabled", true);
            this.hideAdvancementList = builder.comment(" List of advancement that will not be sent. 'modid' will remove every advancement from a mod (ex:minecraft) and modid:path/to/advancement will remove every advancement under this path (ex: minecraft:nether").defineList("hideAdvancementList", ArrayList::new, e -> e instanceof String);
            builder.pop();
        }
    }
}

