/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.minecraft2discord;

import com.mojang.brigadier.CommandDispatcher;
import javax.security.auth.login.LoginException;
import ml.denis3d.minecraft2discord.BotEvents;
import ml.denis3d.minecraft2discord.Config;
import ml.denis3d.minecraft2discord.DiscordCommand;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.JDABuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="minecraft2discord")
public class Minecraft2Discord {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JDA DISCORD_BOT = null;

    public Minecraft2Discord() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onServerReady);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onServerStop);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.SERVER_SPECS);
    }

    public static JDA getDiscordBot() {
        return DISCORD_BOT;
    }

    public void onServerReady(FMLServerStartingEvent event) {
        if (((Boolean)Config.SERVER.discordCommandEnabled.get()).booleanValue()) {
            DiscordCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        }
        try {
            DISCORD_BOT = new JDABuilder((String)Config.SERVER.botToken.get()).addEventListener(new BotEvents()).build();
        }
        catch (LoginException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void onServerStop(FMLServerStoppingEvent event) {
        if (((Boolean)Config.SERVER.sendServerStartStopMessages.get()).booleanValue() || (Long)Config.SERVER.infoChannel.get() == 0L) {
            if (Minecraft2Discord.getDiscordBot() == null) {
                return;
            }
            TextChannel infoChannel = DISCORD_BOT.getTextChannelById((Long)Config.SERVER.infoChannel.get());
            if (infoChannel != null) {
                infoChannel.sendMessage((CharSequence)Config.SERVER.serverStopMessage.get()).queue();
            }
        }
        DISCORD_BOT.shutdown();
    }
}

