/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.com.neovisionaries.ws.client;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import ml.denis3d.repack.com.neovisionaries.ws.client.Address;
import ml.denis3d.repack.com.neovisionaries.ws.client.Misc;
import ml.denis3d.repack.com.neovisionaries.ws.client.ProxyHandshaker;
import ml.denis3d.repack.com.neovisionaries.ws.client.ProxySettings;
import ml.denis3d.repack.com.neovisionaries.ws.client.SNIHelper;
import ml.denis3d.repack.com.neovisionaries.ws.client.SocketConnector;
import ml.denis3d.repack.com.neovisionaries.ws.client.SocketFactorySettings;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocket;

public class WebSocketFactory {
    private final SocketFactorySettings mSocketFactorySettings = new SocketFactorySettings();
    private final ProxySettings mProxySettings = new ProxySettings(this);
    private int mConnectionTimeout;
    private boolean mVerifyHostname = true;
    private String[] mServerNames;

    public SocketFactory getSocketFactory() {
        return this.mSocketFactorySettings.getSocketFactory();
    }

    public WebSocketFactory setSocketFactory(SocketFactory factory) {
        this.mSocketFactorySettings.setSocketFactory(factory);
        return this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSocketFactorySettings.getSSLSocketFactory();
    }

    public WebSocketFactory setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSocketFactorySettings.setSSLSocketFactory(factory);
        return this;
    }

    public SSLContext getSSLContext() {
        return this.mSocketFactorySettings.getSSLContext();
    }

    public WebSocketFactory setSSLContext(SSLContext context) {
        this.mSocketFactorySettings.setSSLContext(context);
        return this;
    }

    public ProxySettings getProxySettings() {
        return this.mProxySettings;
    }

    public int getConnectionTimeout() {
        return this.mConnectionTimeout;
    }

    public WebSocketFactory setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout value cannot be negative.");
        }
        this.mConnectionTimeout = timeout;
        return this;
    }

    public boolean getVerifyHostname() {
        return this.mVerifyHostname;
    }

    public WebSocketFactory setVerifyHostname(boolean verifyHostname) {
        this.mVerifyHostname = verifyHostname;
        return this;
    }

    public String[] getServerNames() {
        return this.mServerNames;
    }

    public WebSocketFactory setServerNames(String[] serverNames) {
        this.mServerNames = serverNames;
        return this;
    }

    public WebSocketFactory setServerName(String serverName) {
        return this.setServerNames(new String[]{serverName});
    }

    public WebSocket createSocket(String uri) throws IOException {
        return this.createSocket(uri, this.getConnectionTimeout());
    }

    public WebSocket createSocket(String uri, int timeout) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        return this.createSocket(URI.create(uri), timeout);
    }

    public WebSocket createSocket(URL url) throws IOException {
        return this.createSocket(url, this.getConnectionTimeout());
    }

    public WebSocket createSocket(URL url, int timeout) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The given URL is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        try {
            return this.createSocket(url.toURI(), timeout);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert the given URL into a URI.");
        }
    }

    public WebSocket createSocket(URI uri) throws IOException {
        return this.createSocket(uri, this.getConnectionTimeout());
    }

    public WebSocket createSocket(URI uri, int timeout) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        String scheme = uri.getScheme();
        String userInfo = uri.getUserInfo();
        String host = Misc.extractHost(uri);
        int port = uri.getPort();
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        return this.createSocket(scheme, userInfo, host, port, path, query, timeout);
    }

    private WebSocket createSocket(String scheme, String userInfo, String host, int port, String path, String query, int timeout) throws IOException {
        boolean secure = WebSocketFactory.isSecureConnectionRequired(scheme);
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("The host part is empty.");
        }
        path = WebSocketFactory.determinePath(path);
        SocketConnector connector = this.createRawSocket(host, port, secure, timeout);
        return this.createWebSocket(secure, userInfo, host, port, path, query, connector);
    }

    private static boolean isSecureConnectionRequired(String scheme) {
        if (scheme == null || scheme.length() == 0) {
            throw new IllegalArgumentException("The scheme part is empty.");
        }
        if ("wss".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return true;
        }
        if ("ws".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme)) {
            return false;
        }
        throw new IllegalArgumentException("Bad scheme: " + scheme);
    }

    private static String determinePath(String path) {
        if (path == null || path.length() == 0) {
            return "/";
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private SocketConnector createRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        boolean proxied;
        port = WebSocketFactory.determinePort(port, secure);
        boolean bl = proxied = this.mProxySettings.getHost() != null;
        if (proxied) {
            return this.createProxiedRawSocket(host, port, secure, timeout);
        }
        return this.createDirectRawSocket(host, port, secure, timeout);
    }

    private SocketConnector createProxiedRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        int proxyPort = WebSocketFactory.determinePort(this.mProxySettings.getPort(), this.mProxySettings.isSecure());
        SocketFactory socketFactory = this.mProxySettings.selectSocketFactory();
        Socket socket = socketFactory.createSocket();
        SNIHelper.setServerNames(socket, this.mProxySettings.getServerNames());
        Address address = new Address(this.mProxySettings.getHost(), proxyPort);
        ProxyHandshaker handshaker = new ProxyHandshaker(socket, host, port, this.mProxySettings);
        SSLSocketFactory sslSocketFactory = secure ? (SSLSocketFactory)this.mSocketFactorySettings.selectSocketFactory(secure) : null;
        return new SocketConnector(socket, address, timeout, handshaker, sslSocketFactory, host, port).setVerifyHostname(this.mVerifyHostname);
    }

    private SocketConnector createDirectRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        SocketFactory factory = this.mSocketFactorySettings.selectSocketFactory(secure);
        Socket socket = factory.createSocket();
        SNIHelper.setServerNames(socket, this.mServerNames);
        Address address = new Address(host, port);
        return new SocketConnector(socket, address, timeout).setVerifyHostname(this.mVerifyHostname);
    }

    private static int determinePort(int port, boolean secure) {
        if (0 <= port) {
            return port;
        }
        if (secure) {
            return 443;
        }
        return 80;
    }

    private WebSocket createWebSocket(boolean secure, String userInfo, String host, int port, String path, String query, SocketConnector connector) {
        if (0 <= port) {
            host = host + ":" + port;
        }
        if (query != null) {
            path = path + "?" + query;
        }
        return new WebSocket(this, secure, userInfo, host, path, connector);
    }
}

