/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.com.neovisionaries.ws.client;

import ml.denis3d.repack.com.neovisionaries.ws.client.ListenerManager;
import ml.denis3d.repack.com.neovisionaries.ws.client.ThreadType;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocket;

abstract class WebSocketThread
extends Thread {
    protected final WebSocket mWebSocket;
    private final ThreadType mThreadType;

    WebSocketThread(String name, WebSocket ws, ThreadType type) {
        super(name);
        this.mWebSocket = ws;
        this.mThreadType = type;
    }

    public void run() {
        ListenerManager lm = this.mWebSocket.getListenerManager();
        if (lm != null) {
            lm.callOnThreadStarted(this.mThreadType, this);
        }
        this.runMain();
        if (lm != null) {
            lm.callOnThreadStopping(this.mThreadType, this);
        }
    }

    public void callOnThreadCreated() {
        ListenerManager lm = this.mWebSocket.getListenerManager();
        if (lm != null) {
            lm.callOnThreadCreated(this.mThreadType, this);
        }
    }

    protected abstract void runMain();
}

