/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.client.entities.impl;

import java.util.Collections;
import java.util.List;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.AuthorizedApplication;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;

public class AuthorizedApplicationImpl
implements AuthorizedApplication {
    private final JDA api;
    private final long id;
    private final long authId;
    private final String description;
    private final String iconId;
    private final String name;
    private final List<String> scopes;

    public AuthorizedApplicationImpl(JDA api, long authId, String description, String iconId, long id, String name, List<String> scopes) {
        this.api = api;
        this.authId = authId;
        this.description = description;
        this.iconId = iconId;
        this.id = id;
        this.name = name;
        this.scopes = Collections.unmodifiableList(scopes);
    }

    @Override
    public RestAction<Void> delete() {
        Route.CompiledRoute route = Route.Applications.DELETE_AUTHORIZED_APPLICATION.compile(this.getAuthId());
        return new RestAction<Void>(this.api, route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof AuthorizedApplicationImpl && this.id == ((AuthorizedApplicationImpl)obj).id;
    }

    @Override
    public String getAuthId() {
        return Long.toUnsignedString(this.authId);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/app-icons/" + this.id + '/' + this.iconId + ".png";
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "AuthorizedApplication(" + this.id + ")";
    }
}

