/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.client.handle;

import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.CallImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.CallUserImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.events.group.GroupUserJoinEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.org.json.JSONObject;

public class ChannelRecipientAddHandler
extends SocketHandler {
    public ChannelRecipientAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long groupId = content.getLong("channel_id");
        JSONObject userJson = content.getJSONObject("user");
        GroupImpl group = (GroupImpl)this.getJDA().asClient().getGroupById(groupId);
        if (group == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, groupId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a CHANNEL_RECIPIENT_ADD for a group that is not yet cached! JSON: {}", (Object)content);
            return null;
        }
        UserImpl user = this.getJDA().getEntityBuilder().createFakeUser(userJson, true);
        group.getUserMap().put(user.getIdLong(), user);
        CallImpl call = (CallImpl)group.getCurrentCall();
        if (call != null) {
            call.getCallUserMap().put(user.getIdLong(), new CallUserImpl(call, user));
        }
        this.getJDA().getEventManager().handle(new GroupUserJoinEvent(this.getJDA(), this.responseNumber, group, user));
        this.getJDA().getEventCache().playbackCache(EventCache.Type.USER, user.getIdLong());
        return null;
    }
}

