/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.client.managers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.Application;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.ApplicationImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Icon;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.ManagerBase;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONObject;

public class ApplicationManager
extends ManagerBase {
    public static final long DESCRIPTION = 1L;
    public static final long ICON = 2L;
    public static final long NAME = 4L;
    public static final long REDIRECT_URI = 8L;
    public static final long PUBLIC = 16L;
    public static final long CODE_GRANT = 32L;
    protected final ApplicationImpl application;
    protected final List<String> redirectUris = new ArrayList<String>();
    protected String name;
    protected String description;
    protected Icon icon;
    protected boolean isPublic;
    protected boolean isCodeGrant;

    public ApplicationManager(ApplicationImpl application) {
        super(application.getJDA(), Route.Applications.MODIFY_APPLICATION.compile(application.getId()));
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    @CheckReturnValue
    public ApplicationManager reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.icon = null;
        }
        if ((fields & 8L) == 8L) {
            this.withLock(this.redirectUris, List::clear);
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public ApplicationManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public ApplicationManager reset() {
        super.reset();
        this.icon = null;
        this.withLock(this.redirectUris, List::clear);
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setDescription(String description) {
        Checks.check(description == null || description.length() <= 400, "Description must be less or equal to 400 characters in length");
        this.description = description;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setDoesBotRequireCodeGrant(boolean requireCodeGrant) {
        this.isCodeGrant = requireCodeGrant;
        this.set |= 0x20L;
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setIcon(Icon icon) {
        this.icon = icon;
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setIsBotPublic(boolean botPublic) {
        this.isPublic = botPublic;
        this.set |= 0x10L;
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setName(String name) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 32, "Name must be between 2-32 characters long");
        this.name = name;
        this.set |= 4L;
        return this;
    }

    @CheckReturnValue
    public ApplicationManager setRedirectUris(List<String> redirectUris) {
        if (redirectUris == null) {
            this.withLock(this.redirectUris, List::clear);
        } else {
            Checks.noneNull(redirectUris, "Redirects");
            this.withLock(this.redirectUris, list -> {
                list.clear();
                list.addAll(redirectUris);
            });
        }
        this.set |= 8L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject body = new JSONObject();
        body.put("description", this.shouldUpdate(1L) ? this.opt(this.description) : this.application.getDescription());
        body.put("bot_require_code_grant", this.shouldUpdate(32L) ? this.isCodeGrant : this.application.doesBotRequireCodeGrant());
        body.put("icon", this.shouldUpdate(2L) ? (this.icon == null ? JSONObject.NULL : this.icon.getEncoding()) : this.application.getIconUrl());
        body.put("bot_public", this.shouldUpdate(16L) ? this.isPublic : this.application.isBotPublic());
        body.put("name", this.shouldUpdate(4L) ? this.name : this.application.getName());
        this.withLock(this.redirectUris, list -> body.put("redirect_uris", this.shouldUpdate(8L) ? list : this.application.getRedirectUris()));
        this.reset();
        return this.getRequestBody(body);
    }
}

