/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.client.requests.restaction;

import java.util.function.BooleanSupplier;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.Application;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Icon;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.okhttp3.RequestBody;
import ml.denis3d.repack.org.json.JSONObject;

public class ApplicationAction
extends RestAction<Application> {
    protected String description = null;
    protected Icon icon = null;
    protected String name = null;

    public ApplicationAction(JDAImpl api, String name) {
        super(api, Route.Applications.CREATE_APPLICATION.compile(new String[0]));
        this.setName(name);
    }

    public ApplicationAction setCheck(BooleanSupplier checks) {
        return (ApplicationAction)super.setCheck(checks);
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.put("description", this.description);
        }
        if (this.icon != null) {
            object.put("icon", this.icon.getEncoding());
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Application> request) {
        if (response.isOk()) {
            request.onSuccess(((JDAImpl)this.api.get()).getEntityBuilder().createApplication(response.getObject()));
        } else {
            request.onFailure(response);
        }
    }

    public ApplicationAction setDescription(String description) {
        if (description != null && description.length() > 400) {
            throw new IllegalArgumentException("The description must not be more than 400 characters!");
        }
        this.description = description;
        return this;
    }

    public ApplicationAction setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public ApplicationAction setName(String name) {
        if (name == null || name.length() < 2 || name.length() > 32) {
            throw new IllegalArgumentException("The application name must not be null and in the range of 2-32!");
        }
        this.name = name;
        return this;
    }
}

