/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities;

import java.util.Objects;
import javax.annotation.Nullable;
import ml.denis3d.repack.net.dv8tion.jda.annotations.Incubating;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.RichPresence;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;

public class Game {
    protected final String name;
    protected final String url;
    protected final GameType type;
    protected final RichPresence.Timestamps timestamps;

    protected Game(String name) {
        this(name, null, GameType.DEFAULT);
    }

    protected Game(String name, String url) {
        this(name, url, GameType.STREAMING);
    }

    protected Game(String name, String url, GameType type) {
        this(name, url, type, null);
    }

    protected Game(String name, String url, GameType type, RichPresence.Timestamps timestamps) {
        this.name = name;
        this.url = url;
        this.type = type;
        this.timestamps = timestamps;
    }

    public boolean isRich() {
        return false;
    }

    public RichPresence asRichPresence() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public GameType getType() {
        return this.type;
    }

    @Nullable
    public RichPresence.Timestamps getTimestamps() {
        return this.timestamps;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Game)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Game oGame = (Game)o;
        return oGame.getType() == this.type && Objects.equals(this.name, oGame.getName()) && Objects.equals(this.url, oGame.getUrl()) && Objects.equals(this.timestamps, oGame.timestamps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.url, this.timestamps});
    }

    public String toString() {
        if (this.url != null) {
            return String.format("Game(%s | %s)", this.name, this.url);
        }
        return String.format("Game(%s)", this.name);
    }

    public static Game playing(String name) {
        Checks.notBlank(name, "Name");
        return new Game(name, null, GameType.DEFAULT);
    }

    public static Game streaming(String name, String url) {
        Checks.notEmpty(name, "Provided game name");
        GameType type = Game.isValidStreamingUrl(url) ? GameType.STREAMING : GameType.DEFAULT;
        return new Game(name, url, type);
    }

    public static Game listening(String name) {
        Checks.notBlank(name, "Name");
        return new Game(name, null, GameType.LISTENING);
    }

    @Incubating
    public static Game watching(String name) {
        Checks.notBlank(name, "Name");
        return new Game(name, null, GameType.WATCHING);
    }

    public static Game of(GameType type, String name) {
        return Game.of(type, name, null);
    }

    public static Game of(GameType type, String name, String url) {
        Checks.notNull((Object)type, "Type");
        switch (type) {
            case DEFAULT: {
                return Game.playing(name);
            }
            case STREAMING: {
                return Game.streaming(name, url);
            }
            case LISTENING: {
                return Game.listening(name);
            }
            case WATCHING: {
                return Game.watching(name);
            }
        }
        throw new IllegalArgumentException("GameType " + (Object)((Object)type) + " is not supported!");
    }

    public static boolean isValidStreamingUrl(String url) {
        return url != null && url.matches("https?://(www\\.)?twitch\\.tv/.+");
    }

    public static enum GameType {
        DEFAULT(0),
        STREAMING(1),
        LISTENING(2),
        WATCHING(3);

        private final int key;

        private GameType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static GameType fromKey(int key) {
            switch (key) {
                default: {
                    return DEFAULT;
                }
                case 1: {
                    return STREAMING;
                }
                case 2: {
                    return LISTENING;
                }
                case 3: 
            }
            return WATCHING;
        }
    }
}

