/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Message;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.org.apache.commons.collections4.map.ListOrderedMap;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONException;
import ml.denis3d.repack.org.json.JSONObject;

public class MessageHistory {
    protected final MessageChannel channel;
    protected final ListOrderedMap<Long, Message> history = new ListOrderedMap();

    public MessageHistory(MessageChannel channel) {
        this.channel = channel;
        if (channel instanceof TextChannel) {
            TextChannel tc = (TextChannel)channel;
            if (!tc.getGuild().getSelfMember().hasPermission((Channel)tc, Permission.MESSAGE_HISTORY)) {
                throw new InsufficientPermissionException(Permission.MESSAGE_HISTORY);
            }
        }
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public int size() {
        return this.history.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    @CheckReturnValue
    public RestAction<List<Message>> retrievePast(int amount) {
        if (amount > 100 || amount < 1) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(this.channel.getId()).withQueryParams("limit", Integer.toString(amount));
        if (!this.history.isEmpty()) {
            route = route.withQueryParams("before", String.valueOf(this.history.lastKey()));
        }
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                msgs.forEach(msg -> MessageHistory.this.history.put(msg.getIdLong(), (Message)msg));
                request.onSuccess(msgs);
            }
        };
    }

    @CheckReturnValue
    public RestAction<List<Message>> retrieveFuture(int amount) {
        if (amount > 100 || amount < 1) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        if (this.history.isEmpty()) {
            throw new IllegalStateException("No messages have been retrieved yet, so there is no message to act as a marker to retrieve more recent messages based on.");
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(this.channel.getId()).withQueryParams("limit", Integer.toString(amount), "after", String.valueOf(this.history.firstKey()));
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                Iterator it = msgs.descendingIterator();
                while (it.hasNext()) {
                    Message m = (Message)it.next();
                    MessageHistory.this.history.put(0, m.getIdLong(), m);
                }
                request.onSuccess(msgs);
            }
        };
    }

    public List<Message> getRetrievedHistory() {
        int size = this.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(this.history.getValue(0));
        }
        return Collections.unmodifiableList(new ArrayList<Message>(this.history.values()));
    }

    public Message getMessageById(String id) {
        return this.getMessageById(MiscUtil.parseSnowflake(id));
    }

    public Message getMessageById(long id) {
        return (Message)this.history.get(id);
    }

    public static MessageRetrieveAction getHistoryAfter(MessageChannel channel, String messageId) {
        MessageHistory.checkArguments(channel, messageId);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(channel.getId()).withQueryParams("after", messageId);
        return new MessageRetrieveAction(route, channel);
    }

    public static MessageRetrieveAction getHistoryBefore(MessageChannel channel, String messageId) {
        MessageHistory.checkArguments(channel, messageId);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(channel.getId()).withQueryParams("before", messageId);
        return new MessageRetrieveAction(route, channel);
    }

    public static MessageRetrieveAction getHistoryAround(MessageChannel channel, String messageId) {
        MessageHistory.checkArguments(channel, messageId);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(channel.getId()).withQueryParams("around", messageId);
        return new MessageRetrieveAction(route, channel);
    }

    private static void checkArguments(MessageChannel channel, String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(channel, "Channel");
        if (channel.getType() == ChannelType.TEXT) {
            TextChannel t = (TextChannel)channel;
            if (!t.getGuild().getSelfMember().hasPermission((Channel)t, Permission.MESSAGE_HISTORY)) {
                throw new InsufficientPermissionException(Permission.MESSAGE_HISTORY);
            }
        }
    }

    public static class MessageRetrieveAction
    extends RestAction<MessageHistory> {
        private final MessageChannel channel;
        private Integer limit;

        protected MessageRetrieveAction(Route.CompiledRoute route, MessageChannel channel) {
            super(channel.getJDA(), route);
            this.channel = channel;
        }

        public MessageRetrieveAction limit(Integer limit) {
            if (limit != null) {
                Checks.positive(limit, "Limit");
                Checks.check(limit <= 100, "Limit may not exceed 100!");
            }
            this.limit = limit;
            return this;
        }

        @Override
        protected Route.CompiledRoute finalizeRoute() {
            Route.CompiledRoute route = super.finalizeRoute();
            return this.limit == null ? route : route.withQueryParams("limit", String.valueOf(this.limit));
        }

        @Override
        protected void handleResponse(Response response, Request<MessageHistory> request) {
            if (!response.isOk()) {
                request.onFailure(response);
                return;
            }
            MessageHistory result = new MessageHistory(this.channel);
            JSONArray array = response.getArray();
            EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
            for (int i = 0; i < array.length(); ++i) {
                try {
                    JSONObject obj = array.getJSONObject(i);
                    result.history.put(obj.getLong("id"), builder.createMessage(obj, this.channel, false));
                    continue;
                }
                catch (NullPointerException | JSONException e) {
                    LOG.warn("Encountered exception in MessagePagination", e);
                }
            }
            request.onSuccess(result);
        }
    }
}

