/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities.impl;

import ml.denis3d.repack.net.dv8tion.jda.core.entities.AudioChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.GuildVoiceState;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.UpstreamReference;

public class GuildVoiceStateImpl
implements GuildVoiceState {
    private final UpstreamReference<GuildImpl> guild;
    private final UpstreamReference<Member> member;
    private VoiceChannel connectedChannel;
    private String sessionId;
    private boolean selfMuted = false;
    private boolean selfDeafened = false;
    private boolean guildMuted = false;
    private boolean guildDeafened = false;
    private boolean suppressed = false;

    public GuildVoiceStateImpl(GuildImpl guild, Member member) {
        this.guild = new UpstreamReference<GuildImpl>(guild);
        this.member = new UpstreamReference<Member>(member);
    }

    @Override
    public boolean isSelfMuted() {
        return this.selfMuted;
    }

    @Override
    public boolean isSelfDeafened() {
        return this.selfDeafened;
    }

    @Override
    public JDAImpl getJDA() {
        return this.getGuild().getJDA();
    }

    @Override
    public AudioChannel getAudioChannel() {
        return this.connectedChannel;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isMuted() {
        return this.isSelfMuted() || this.isGuildMuted();
    }

    @Override
    public boolean isDeafened() {
        return this.isSelfDeafened() || this.isGuildDeafened();
    }

    @Override
    public boolean isGuildMuted() {
        return this.guildMuted;
    }

    @Override
    public boolean isGuildDeafened() {
        return this.guildDeafened;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public VoiceChannel getChannel() {
        return this.connectedChannel;
    }

    @Override
    public GuildImpl getGuild() {
        return this.guild.get();
    }

    @Override
    public Member getMember() {
        return this.member.get();
    }

    @Override
    public boolean inVoiceChannel() {
        return this.getChannel() != null;
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuildVoiceState)) {
            return false;
        }
        GuildVoiceState oStatus = (GuildVoiceState)obj;
        return this == oStatus || this.getMember().equals(oStatus.getMember()) && this.getGuild().equals(oStatus.getGuild());
    }

    public String toString() {
        return "VS:" + this.getGuild().getName() + ':' + this.getMember().getEffectiveName();
    }

    public GuildVoiceStateImpl setConnectedChannel(VoiceChannel connectedChannel) {
        this.connectedChannel = connectedChannel;
        return this;
    }

    public GuildVoiceStateImpl setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public GuildVoiceStateImpl setSelfMuted(boolean selfMuted) {
        this.selfMuted = selfMuted;
        return this;
    }

    public GuildVoiceStateImpl setSelfDeafened(boolean selfDeafened) {
        this.selfDeafened = selfDeafened;
        return this;
    }

    public GuildVoiceStateImpl setGuildMuted(boolean guildMuted) {
        this.guildMuted = guildMuted;
        return this;
    }

    public GuildVoiceStateImpl setGuildDeafened(boolean guildDeafened) {
        this.guildDeafened = guildDeafened;
        return this;
    }

    public GuildVoiceStateImpl setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
        return this;
    }
}

