/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import ml.denis3d.repack.com.neovisionaries.ws.client.WebSocketFactory;
import ml.denis3d.repack.gnu.trove.map.TLongObjectMap;
import ml.denis3d.repack.net.dv8tion.jda.annotations.DeprecatedSince;
import ml.denis3d.repack.net.dv8tion.jda.annotations.ReplaceWith;
import ml.denis3d.repack.net.dv8tion.jda.bot.entities.impl.JDABotImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.factory.DefaultSendFactory;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import ml.denis3d.repack.net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Category;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Emote;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.SelfUser;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.User;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Webhook;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.WebhookImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.StatusChangeEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.AccountTypeException;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.RateLimitedException;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.GuildSetupController;
import ml.denis3d.repack.net.dv8tion.jda.core.hooks.IEventManager;
import ml.denis3d.repack.net.dv8tion.jda.core.hooks.InterfacedEventManager;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.AudioManager;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.Presence;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.PresenceImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.GuildLock;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Requester;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.RestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.GuildAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Checks;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.JDALogger;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.SessionController;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.SessionControllerAdapter;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.CacheFlag;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.CacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.UpstreamReference;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.impl.AbstractCacheView;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.concurrent.CountingThreadFactory;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.tuple.Pair;
import ml.denis3d.repack.okhttp3.OkHttpClient;
import ml.denis3d.repack.org.json.JSONObject;
import ml.denis3d.repack.org.slf4j.Logger;
import ml.denis3d.repack.org.slf4j.MDC;

public class JDAImpl
implements JDA {
    public static final Logger LOG = JDALogger.getLog(JDA.class);
    protected final ScheduledExecutorService rateLimitPool;
    protected final ScheduledExecutorService gatewayPool;
    protected final ExecutorService callbackPool;
    protected final boolean shutdownRateLimitPool;
    protected final boolean shutdownGatewayPool;
    protected final boolean shutdownCallbackPool;
    protected final Object audioLifeCycleLock = new Object();
    protected ScheduledThreadPoolExecutor audioLifeCyclePool;
    protected final SnowflakeCacheViewImpl<User> userCache = new SnowflakeCacheViewImpl<User>(User.class, User::getName);
    protected final SnowflakeCacheViewImpl<Guild> guildCache = new SnowflakeCacheViewImpl<Guild>(Guild.class, Guild::getName);
    protected final SnowflakeCacheViewImpl<Category> categories = new SnowflakeCacheViewImpl<Category>(Category.class, Channel::getName);
    protected final SnowflakeCacheViewImpl<TextChannel> textChannelCache = new SnowflakeCacheViewImpl<TextChannel>(TextChannel.class, Channel::getName);
    protected final SnowflakeCacheViewImpl<VoiceChannel> voiceChannelCache = new SnowflakeCacheViewImpl<VoiceChannel>(VoiceChannel.class, Channel::getName);
    protected final SnowflakeCacheViewImpl<PrivateChannel> privateChannelCache = new SnowflakeCacheViewImpl<PrivateChannel>(PrivateChannel.class, MessageChannel::getName);
    protected final TLongObjectMap<User> fakeUsers = MiscUtil.newLongMap();
    protected final TLongObjectMap<PrivateChannel> fakePrivateChannels = MiscUtil.newLongMap();
    protected final AbstractCacheView<AudioManager> audioManagers = new CacheView.SimpleCacheView<AudioManager>(AudioManager.class, m -> m.getGuild().getName());
    protected final ConcurrentMap<String, String> contextMap;
    protected final OkHttpClient httpClient;
    protected final WebSocketFactory wsFactory;
    protected final AccountType accountType;
    protected final PresenceImpl presence;
    protected final JDAClientImpl jdaClient;
    protected final JDABotImpl jdaBot;
    protected final int maxReconnectDelay;
    protected final Thread shutdownHook;
    protected final EntityBuilder entityBuilder = new EntityBuilder(this);
    protected final EventCache eventCache = new EventCache();
    protected final EnumSet<CacheFlag> cacheFlags;
    protected final SessionController sessionController;
    protected final GuildSetupController guildSetupController;
    protected UpstreamReference<WebSocketClient> client;
    protected Requester requester;
    protected IEventManager eventManager = new InterfacedEventManager();
    protected IAudioSendFactory audioSendFactory = new DefaultSendFactory();
    protected JDA.Status status = JDA.Status.INITIALIZING;
    protected SelfUser selfUser;
    protected JDA.ShardInfo shardInfo;
    protected boolean audioEnabled;
    protected boolean bulkDeleteSplittingEnabled;
    protected boolean autoReconnect;
    protected long responseTotal;
    protected long ping = -1L;
    protected String token;
    protected String gatewayUrl;

    public JDAImpl(AccountType accountType, String token, SessionController controller, OkHttpClient httpClient, WebSocketFactory wsFactory, ScheduledExecutorService rateLimitPool, ScheduledExecutorService gatewayPool, ExecutorService callbackPool, boolean autoReconnect, boolean audioEnabled, boolean useShutdownHook, boolean bulkDeleteSplittingEnabled, boolean retryOnTimeout, boolean enableMDC, boolean shutdownRateLimitPool, boolean shutdownGatewayPool, boolean shutdownCallbackPool, int poolSize, int maxReconnectDelay, ConcurrentMap<String, String> contextMap, EnumSet<CacheFlag> cacheFlags) {
        this.accountType = accountType;
        this.setToken(token);
        this.httpClient = httpClient;
        this.wsFactory = wsFactory;
        this.autoReconnect = autoReconnect;
        this.audioEnabled = audioEnabled;
        this.shutdownHook = useShutdownHook ? new Thread(this::shutdown, "JDA Shutdown Hook") : null;
        this.bulkDeleteSplittingEnabled = bulkDeleteSplittingEnabled;
        this.rateLimitPool = rateLimitPool == null ? this.newScheduler(poolSize, "RateLimit") : rateLimitPool;
        this.gatewayPool = gatewayPool == null ? this.newScheduler(1, "Gateway") : gatewayPool;
        this.callbackPool = callbackPool == null ? ForkJoinPool.commonPool() : callbackPool;
        this.shutdownRateLimitPool = shutdownRateLimitPool;
        this.shutdownGatewayPool = shutdownGatewayPool;
        this.shutdownCallbackPool = shutdownCallbackPool;
        this.maxReconnectDelay = maxReconnectDelay;
        SessionController sessionController = this.sessionController = controller == null ? new SessionControllerAdapter() : controller;
        this.contextMap = enableMDC ? (contextMap == null ? new ConcurrentHashMap() : contextMap) : null;
        this.presence = new PresenceImpl(this);
        this.requester = new Requester(this);
        this.requester.setRetryOnTimeout(retryOnTimeout);
        this.jdaClient = accountType == AccountType.CLIENT ? new JDAClientImpl(this) : null;
        this.jdaBot = accountType == AccountType.BOT ? new JDABotImpl(this) : null;
        this.guildSetupController = new GuildSetupController(this);
        this.cacheFlags = cacheFlags;
    }

    private ScheduledThreadPoolExecutor newScheduler(int coreSize, String baseName) {
        return new ScheduledThreadPoolExecutor(coreSize, new CountingThreadFactory(this::getIdentifierString, baseName));
    }

    public boolean isCacheFlagSet(CacheFlag flag) {
        return this.cacheFlags.contains((Object)flag);
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    @Deprecated
    @DeprecatedSince(value="3.8.0")
    @ReplaceWith(value="getGuildSetupController()")
    public GuildLock getGuildLock() {
        return new GuildLock(this);
    }

    public GuildSetupController getGuildSetupController() {
        return this.guildSetupController;
    }

    public int login(String gatewayUrl, JDA.ShardInfo shardInfo, boolean compression, boolean validateToken) throws LoginException {
        this.gatewayUrl = gatewayUrl;
        this.shardInfo = shardInfo;
        this.setStatus(JDA.Status.LOGGING_IN);
        if (this.token == null || this.token.isEmpty()) {
            throw new LoginException("Provided token was null or empty!");
        }
        Map<String, String> previousContext = null;
        if (this.contextMap != null) {
            if (shardInfo != null) {
                this.contextMap.put("jda.shard", shardInfo.getShardString());
                this.contextMap.put("jda.shard.id", String.valueOf(shardInfo.getShardId()));
                this.contextMap.put("jda.shard.total", String.valueOf(shardInfo.getShardTotal()));
            }
            previousContext = MDC.getCopyOfContextMap();
            this.contextMap.forEach(MDC::put);
            this.requester.setContextReady(true);
        }
        if (validateToken) {
            this.verifyToken();
            LOG.info("Login Successful!");
        }
        this.client = new UpstreamReference<WebSocketClient>(new WebSocketClient(this, compression));
        if (previousContext != null) {
            previousContext.forEach(MDC::put);
        }
        if (this.shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        return shardInfo == null ? -1 : shardInfo.getShardTotal();
    }

    public String getGateway() {
        return this.getSessionController().getGateway(this);
    }

    public Pair<String, Integer> getGatewayBot() {
        return this.getSessionController().getGatewayBot(this);
    }

    public ConcurrentMap<String, String> getContextMap() {
        return this.contextMap == null ? null : new ConcurrentHashMap<String, String>(this.contextMap);
    }

    public void setContext() {
        if (this.contextMap != null) {
            this.contextMap.forEach(MDC::put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JDA.Status status) {
        JDA.Status status2 = this.status;
        synchronized (status2) {
            JDA.Status oldStatus = this.status;
            this.status = status;
            this.eventManager.handle(new StatusChangeEvent(this, status, oldStatus));
        }
    }

    public void setToken(String token) {
        this.token = this.getAccountType() == AccountType.BOT ? "Bot " + token : token;
    }

    public void verifyToken() throws LoginException {
        this.verifyToken(false);
    }

    public void verifyToken(boolean alreadyFailed) throws LoginException {
        JSONObject userResponse;
        RestAction<JSONObject> login = new RestAction<JSONObject>((JDA)this, Route.Self.GET_SELF.compile(new String[0])){

            @Override
            protected void handleResponse(Response response, Request<JSONObject> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject());
                } else if (response.isRateLimit()) {
                    request.onFailure(new RateLimitedException(request.getRoute(), response.retryAfter));
                } else if (response.code == 401) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString()));
                }
            }
        };
        if (!alreadyFailed && (userResponse = this.checkToken(login)) != null) {
            this.verifyAccountType(userResponse);
            return;
        }
        if (this.getAccountType() == AccountType.BOT) {
            this.token = this.token.substring("Bot ".length());
            this.requester = new Requester(this, AccountType.CLIENT);
        } else {
            this.token = "Bot " + this.token;
            this.requester = new Requester(this, AccountType.BOT);
        }
        userResponse = this.checkToken(login);
        this.shutdownNow();
        if (userResponse == null) {
            throw new LoginException("The provided token is invalid!");
        }
        this.verifyAccountType(userResponse);
    }

    private void verifyAccountType(JSONObject userResponse) {
        if (this.getAccountType() == AccountType.BOT) {
            if (!userResponse.has("bot") || !userResponse.getBoolean("bot")) {
                throw new AccountTypeException(AccountType.BOT, "Attempted to login as a BOT with a CLIENT token!");
            }
        } else if (userResponse.has("bot") && userResponse.getBoolean("bot")) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to login as a CLIENT with a BOT token!");
        }
    }

    private JSONObject checkToken(RestAction<JSONObject> login) throws LoginException {
        JSONObject userResponse;
        try {
            userResponse = login.complete();
        }
        catch (RuntimeException e) {
            Throwable ex;
            Throwable throwable = ex = e.getCause() instanceof ExecutionException ? e.getCause().getCause() : null;
            if (ex instanceof LoginException) {
                throw new LoginException(ex.getMessage());
            }
            throw e;
        }
        return userResponse;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public boolean isBulkDeleteSplittingEnabled() {
        return this.bulkDeleteSplittingEnabled;
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        WebSocketClient client = this.getClient();
        if (client != null) {
            client.setAutoReconnect(autoReconnect);
        }
    }

    @Override
    public void setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.requester.setRetryOnTimeout(retryOnTimeout);
    }

    @Override
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public JDA.Status getStatus() {
        return this.status;
    }

    @Override
    public long getPing() {
        return this.ping;
    }

    @Override
    public JDA awaitStatus(JDA.Status status) throws InterruptedException {
        Checks.notNull((Object)status, "Status");
        Checks.check(status.isInit(), "Cannot await the status %s as it is not part of the login cycle!", (Object)status);
        if (this.getStatus() == JDA.Status.CONNECTED) {
            return this;
        }
        while (!this.getStatus().isInit() || this.getStatus().ordinal() < status.ordinal()) {
            if (this.getStatus() == JDA.Status.SHUTDOWN) {
                throw new IllegalStateException("Was shutdown trying to await status");
            }
            Thread.sleep(50L);
        }
        return this;
    }

    @Override
    public List<String> getCloudflareRays() {
        WebSocketClient client = this.getClient();
        return client == null ? Collections.emptyList() : Collections.unmodifiableList(new LinkedList<String>(client.getCfRays()));
    }

    @Override
    public List<String> getWebSocketTrace() {
        WebSocketClient client = this.getClient();
        return client == null ? Collections.emptyList() : Collections.unmodifiableList(new LinkedList<String>(client.getTraces()));
    }

    @Override
    public List<Guild> getMutualGuilds(User ... users) {
        Checks.notNull(users, "users");
        return this.getMutualGuilds(Arrays.asList(users));
    }

    @Override
    public List<Guild> getMutualGuilds(Collection<User> users) {
        Checks.notNull(users, "users");
        for (User u : users) {
            Checks.notNull(u, "All users");
        }
        return Collections.unmodifiableList(this.getGuilds().stream().filter(guild -> users.stream().allMatch(guild::isMember)).collect(Collectors.toList()));
    }

    @Override
    public RestAction<User> retrieveUserById(String id) {
        return this.retrieveUserById(MiscUtil.parseSnowflake(id));
    }

    @Override
    public RestAction<User> retrieveUserById(long id) {
        AccountTypeException.check(this.accountType, AccountType.BOT);
        User user = this.getUserById(id);
        if (user != null) {
            return new RestAction.EmptyRestAction<User>((JDA)this, user);
        }
        Route.CompiledRoute route = Route.Users.GET_USER.compile(Long.toUnsignedString(id));
        return new RestAction<User>((JDA)this, route){

            @Override
            protected void handleResponse(Response response, Request<User> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject user = response.getObject();
                request.onSuccess(JDAImpl.this.getEntityBuilder().createFakeUser(user, false));
            }
        };
    }

    @Override
    public CacheView<AudioManager> getAudioManagerCache() {
        return this.audioManagers;
    }

    @Override
    public SnowflakeCacheView<Guild> getGuildCache() {
        return this.guildCache;
    }

    @Override
    public SnowflakeCacheView<Role> getRoleCache() {
        return CacheView.allSnowflakes(() -> this.guildCache.stream().map(Guild::getRoleCache));
    }

    @Override
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return CacheView.allSnowflakes(() -> this.guildCache.stream().map(Guild::getEmoteCache));
    }

    @Override
    public SnowflakeCacheView<Category> getCategoryCache() {
        return this.categories;
    }

    @Override
    public SnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.textChannelCache;
    }

    @Override
    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.voiceChannelCache;
    }

    @Override
    public SnowflakeCacheView<PrivateChannel> getPrivateChannelCache() {
        return this.privateChannelCache;
    }

    @Override
    public SnowflakeCacheView<User> getUserCache() {
        return this.userCache;
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    public synchronized void shutdownNow() {
        this.shutdown();
        if (this.shutdownRateLimitPool) {
            this.getRateLimitPool().shutdownNow();
        }
        if (this.shutdownGatewayPool) {
            this.getGatewayPool().shutdownNow();
        }
        if (this.shutdownCallbackPool) {
            this.getCallbackPool().shutdownNow();
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.status == JDA.Status.SHUTDOWN || this.status == JDA.Status.SHUTTING_DOWN) {
            return;
        }
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        WebSocketClient client = this.getClient();
        if (client != null) {
            client.shutdown();
        }
        this.shutdownInternals();
    }

    public synchronized void shutdownInternals() {
        if (this.status == JDA.Status.SHUTDOWN) {
            return;
        }
        this.closeAudioConnections();
        this.guildSetupController.close();
        this.getRequester().shutdown();
        this.shutdownPools();
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
    }

    private void shutdownPools() {
        if (this.audioLifeCyclePool != null) {
            this.audioLifeCyclePool.shutdownNow();
        }
        if (this.shutdownGatewayPool) {
            this.getGatewayPool().shutdown();
        }
        if (this.shutdownCallbackPool) {
            this.getCallbackPool().shutdown();
        }
        if (this.shutdownRateLimitPool) {
            ScheduledExecutorService rateLimitPool = this.getRateLimitPool();
            if (rateLimitPool instanceof ScheduledThreadPoolExecutor) {
                ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)rateLimitPool;
                executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
                executor.allowCoreThreadTimeOut(true);
            } else {
                rateLimitPool.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAudioConnections() {
        TLongObjectMap<AudioManager> managerMap;
        TLongObjectMap<AudioManager> tLongObjectMap = managerMap = this.getAudioManagerMap();
        synchronized (tLongObjectMap) {
            managerMap.valueCollection().stream().map(AudioManagerImpl.class::cast).forEach(m -> m.closeAudioConnection(ConnectionStatus.SHUTTING_DOWN));
            managerMap.clear();
        }
    }

    @Override
    public JDAClientImpl asClient() {
        AccountTypeException.check(this.getAccountType(), AccountType.CLIENT);
        return this.jdaClient;
    }

    @Override
    public JDABotImpl asBot() {
        AccountTypeException.check(this.getAccountType(), AccountType.BOT);
        return this.jdaBot;
    }

    @Override
    public long getResponseTotal() {
        return this.responseTotal;
    }

    @Override
    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    @Override
    public JDA.ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public IEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    public void setEventManager(IEventManager eventManager) {
        this.eventManager = eventManager == null ? new InterfacedEventManager() : eventManager;
    }

    @Override
    public void addEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        for (Object listener : listeners) {
            this.eventManager.register(listener);
        }
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        for (Object listener : listeners) {
            this.eventManager.unregister(listener);
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(this.eventManager.getRegisteredListeners());
    }

    @Override
    public GuildAction createGuild(String name) {
        switch (this.accountType) {
            case BOT: {
                if (this.guildCache.size() < 10L) break;
                throw new IllegalStateException("Cannot create a Guild with a Bot in more than 10 guilds!");
            }
            case CLIENT: {
                if (this.guildCache.size() < 100L) break;
                throw new IllegalStateException("Cannot be in more than 100 guilds with AccountType.CLIENT!");
            }
        }
        return new GuildAction((JDA)this, name);
    }

    @Override
    public RestAction<Webhook> getWebhookById(String webhookId) {
        Checks.isSnowflake(webhookId, "Webhook ID");
        Route.CompiledRoute route = Route.Webhooks.GET_WEBHOOK.compile(webhookId);
        return new RestAction<Webhook>((JDA)this, route){

            @Override
            protected void handleResponse(Response response, Request<Webhook> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject object = response.getObject();
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                WebhookImpl webhook = builder.createWebhook(object);
                request.onSuccess(webhook);
            }
        };
    }

    public EntityBuilder getEntityBuilder() {
        return this.entityBuilder;
    }

    public IAudioSendFactory getAudioSendFactory() {
        return this.audioSendFactory;
    }

    public void setAudioSendFactory(IAudioSendFactory factory) {
        Checks.notNull(factory, "Provided IAudioSendFactory");
        this.audioSendFactory = factory;
    }

    public void setPing(long ping) {
        this.ping = ping;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public WebSocketFactory getWebSocketFactory() {
        return this.wsFactory;
    }

    public WebSocketClient getClient() {
        return this.client == null ? null : this.client.get();
    }

    public TLongObjectMap<User> getUserMap() {
        return this.userCache.getMap();
    }

    public TLongObjectMap<Guild> getGuildMap() {
        return this.guildCache.getMap();
    }

    public TLongObjectMap<Category> getCategoryMap() {
        return this.categories.getMap();
    }

    public TLongObjectMap<TextChannel> getTextChannelMap() {
        return this.textChannelCache.getMap();
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannelCache.getMap();
    }

    public TLongObjectMap<PrivateChannel> getPrivateChannelMap() {
        return this.privateChannelCache.getMap();
    }

    public TLongObjectMap<User> getFakeUserMap() {
        return this.fakeUsers;
    }

    public TLongObjectMap<PrivateChannel> getFakePrivateChannelMap() {
        return this.fakePrivateChannels;
    }

    public TLongObjectMap<AudioManager> getAudioManagerMap() {
        return this.audioManagers.getMap();
    }

    public void setSelfUser(SelfUser selfUser) {
        this.selfUser = selfUser;
    }

    public void setResponseTotal(int responseTotal) {
        this.responseTotal = responseTotal;
    }

    public String getIdentifierString() {
        if (this.shardInfo != null) {
            return "JDA " + this.shardInfo.getShardString();
        }
        return "JDA";
    }

    public EventCache getEventCache() {
        return this.eventCache;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void resetGatewayUrl() {
        this.gatewayUrl = this.getGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledThreadPoolExecutor getAudioLifeCyclePool() {
        ScheduledThreadPoolExecutor pool = this.audioLifeCyclePool;
        if (pool == null) {
            Object object = this.audioLifeCycleLock;
            synchronized (object) {
                pool = this.audioLifeCyclePool;
                if (pool == null) {
                    pool = this.audioLifeCyclePool = this.newScheduler(1, "AudioLifeCycle");
                }
            }
        }
        return pool;
    }

    public ScheduledExecutorService getRateLimitPool() {
        return this.rateLimitPool;
    }

    public ScheduledExecutorService getGatewayPool() {
        return this.gatewayPool;
    }

    public ExecutorService getCallbackPool() {
        return this.callbackPool;
    }
}

