/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.Permission;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Channel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.IPermissionHolder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.PermOverrideManager;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.cache.UpstreamReference;

public class PermissionOverrideImpl
implements PermissionOverride {
    private final long id;
    private final UpstreamReference<Channel> channel;
    private final IPermissionHolder permissionHolder;
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile PermOverrideManager manager;
    private long allow;
    private long deny;

    public PermissionOverrideImpl(Channel channel, long id, IPermissionHolder permissionHolder) {
        this.channel = new UpstreamReference<Channel>(channel);
        this.id = id;
        this.permissionHolder = permissionHolder;
    }

    @Override
    public long getAllowedRaw() {
        return this.allow;
    }

    @Override
    public long getInheritRaw() {
        return (this.allow | this.deny) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getDeniedRaw() {
        return this.deny;
    }

    @Override
    public List<Permission> getAllowed() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    @Override
    public List<Permission> getInherit() {
        return Collections.unmodifiableList(Permission.getPermissions(this.getInheritRaw()));
    }

    @Override
    public List<Permission> getDenied() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    @Override
    public JDA getJDA() {
        return this.getChannel().getJDA();
    }

    @Override
    public Member getMember() {
        return this.isMemberOverride() ? (Member)this.permissionHolder : null;
    }

    @Override
    public Role getRole() {
        return this.isRoleOverride() ? (Role)this.permissionHolder : null;
    }

    @Override
    public Channel getChannel() {
        return this.channel.get();
    }

    @Override
    public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @Override
    public boolean isMemberOverride() {
        return this.permissionHolder instanceof Member;
    }

    @Override
    public boolean isRoleOverride() {
        return this.permissionHolder instanceof Role;
    }

    @Override
    public PermOverrideManager getManager() {
        PermOverrideManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new PermOverrideManager(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        String targetId = this.isRoleOverride() ? this.getRole().getId() : this.getMember().getUser().getId();
        Route.CompiledRoute route = Route.Channels.DELETE_PERM_OVERRIDE.compile(this.getChannel().getId(), targetId);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public PermissionOverrideImpl setAllow(long allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(long deny) {
        this.deny = deny;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PermissionOverrideImpl)) {
            return false;
        }
        PermissionOverrideImpl oPerm = (PermissionOverrideImpl)o;
        return this == oPerm || this.permissionHolder.equals(oPerm.permissionHolder) && this.getChannel().equals(oPerm.getChannel());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "PermOver:(" + (this.isMemberOverride() ? "M" : "R") + ")(" + this.getChannel().getId() + " | " + this.id + ")";
    }
}

