/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.entities.impl;

import java.util.concurrent.locks.ReentrantLock;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.User;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Webhook;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.WebhookManager;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Request;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Requester;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Response;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.Route;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.net.dv8tion.jda.webhook.WebhookClientBuilder;

public class WebhookImpl
implements Webhook {
    protected volatile WebhookManager manager = null;
    private final ReentrantLock mngLock = new ReentrantLock();
    private final TextChannel channel;
    private final long id;
    private Member owner;
    private User user;
    private String token;

    public WebhookImpl(TextChannel channel, long id) {
        this.channel = channel;
        this.id = id;
    }

    @Override
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    public TextChannel getChannel() {
        return this.channel;
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public User getDefaultUser() {
        return this.user;
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getUrl() {
        return Requester.DISCORD_API_PREFIX + "webhooks/" + this.getId() + (this.getToken() == null ? "" : "/" + this.getToken());
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (this.isFake()) {
            throw new IllegalStateException("Fake Webhooks (such as those retrieved from Audit Logs) cannot be used for deletion!");
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_TOKEN_WEBHOOK.compile(this.getId(), this.token);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public WebhookManager getManager() {
        if (this.isFake()) {
            throw new IllegalStateException("Fake Webhooks (such as those retrieved from Audit Logs) cannot provide a WebhookManager!");
        }
        WebhookManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new WebhookManager(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public WebhookClientBuilder newClient() {
        if (this.isFake()) {
            throw new IllegalStateException("Fake Webhooks (such as those retrieved from Audit Logs) cannot be used to create a WebhookClient!");
        }
        return new WebhookClientBuilder(this.id, this.token);
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.token == null;
    }

    public WebhookImpl setOwner(Member member) {
        this.owner = member;
        return this;
    }

    public WebhookImpl setToken(String token) {
        this.token = token;
        return this;
    }

    public WebhookImpl setUser(User user) {
        this.user = user;
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        return obj instanceof WebhookImpl && ((WebhookImpl)obj).id == this.id;
    }

    public String toString() {
        return "WH:" + this.getName() + "(" + this.id + ")";
    }
}

