/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.events.message;

import ml.denis3d.repack.net.dv8tion.jda.client.entities.Group;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.events.Event;

public abstract class GenericMessageEvent
extends Event {
    protected final long messageId;
    protected final MessageChannel channel;

    public GenericMessageEvent(JDA api, long responseNumber, long messageId, MessageChannel channel) {
        super(api, responseNumber);
        this.messageId = messageId;
        this.channel = channel;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public boolean isFromType(ChannelType type) {
        return this.channel.getType() == type;
    }

    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getGuild() : null;
    }

    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }

    public Group getGroup() {
        return this.isFromType(ChannelType.GROUP) ? (Group)this.channel : null;
    }
}

