/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import ml.denis3d.repack.net.dv8tion.jda.client.events.group.GroupJoinEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.category.CategoryCreateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.priv.PrivateChannelCreateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.TextChannelCreateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.VoiceChannelCreateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.org.json.JSONObject;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        switch (type) {
            case NEWS: 
            case TEXT: {
                this.getJDA().getEventManager().handle(new TextChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createTextChannel(content, guildId)));
                break;
            }
            case VOICE: {
                this.getJDA().getEventManager().handle(new VoiceChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createVoiceChannel(content, guildId)));
                break;
            }
            case CATEGORY: {
                this.getJDA().getEventManager().handle(new CategoryCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createCategory(content, guildId)));
                break;
            }
            case PRIVATE: {
                this.getJDA().getEventManager().handle(new PrivateChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createPrivateChannel(content)));
                break;
            }
            case GROUP: {
                this.getJDA().getEventManager().handle(new GroupJoinEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createGroup(content)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: " + content);
            }
        }
        return null;
    }
}

