/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ml.denis3d.repack.gnu.trove.TDecorators;
import ml.denis3d.repack.gnu.trove.list.linked.TLongLinkedList;
import ml.denis3d.repack.gnu.trove.map.TLongObjectMap;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateIconEvent;
import ml.denis3d.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateNameEvent;
import ml.denis3d.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateOwnerEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Category;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.ChannelType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.IMentionable;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.IPermissionHolder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Member;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Role;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.User;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.CategoryImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.category.update.CategoryUpdateNameEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.category.update.CategoryUpdatePermissionsEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.category.update.CategoryUpdatePositionEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNSFWEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNameEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateParentEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePermissionsEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePositionEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateSlowmodeEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateTopicEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateBitrateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateNameEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateParentEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePermissionsEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePositionEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateUserLimitEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.Helpers;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONObject;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            this.handleGroup(content);
            return null;
        }
        ArrayList<IPermissionHolder> changed = new ArrayList<IPermissionHolder>();
        ArrayList<IPermissionHolder> contained = new ArrayList<IPermissionHolder>();
        long channelId = content.getLong("id");
        Long parentId = content.isNull("parent_id") ? null : Long.valueOf(content.getLong("parent_id"));
        int position = content.getInt("position");
        String name = content.getString("name");
        boolean nsfw = Helpers.optBoolean(content, "nsfw");
        int slowmode = Helpers.optInt(content, "rate_limit_per_user", 0);
        JSONArray permOverwrites = content.getJSONArray("permission_overwrites");
        switch (type) {
            case NEWS: 
            case TEXT: {
                String topic = content.optString("topic", null);
                TextChannelImpl textChannel = (TextChannelImpl)this.getJDA().getTextChannelMap().get(channelId);
                if (textChannel == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a TextChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = textChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = textChannel.getName();
                String oldTopic = textChannel.getTopic();
                int oldPosition = textChannel.getPositionRaw();
                boolean oldNsfw = textChannel.isNSFW();
                int oldSlowmode = textChannel.getSlowmode();
                if (!Objects.equals(oldName, name)) {
                    textChannel.setName(name);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateNameEvent(this.getJDA(), this.responseNumber, textChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    textChannel.setParent(parentId == null ? 0L : parentId);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateParentEvent(this.getJDA(), this.responseNumber, textChannel, parent));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    textChannel.setTopic(topic);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateTopicEvent(this.getJDA(), this.responseNumber, textChannel, oldTopic));
                }
                if (oldPosition != position) {
                    textChannel.setPosition(position);
                    this.getJDA().getEventManager().handle(new TextChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, textChannel, oldPosition));
                }
                if (oldNsfw != nsfw) {
                    textChannel.setNSFW(nsfw);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, textChannel, oldNsfw));
                }
                if (oldSlowmode != slowmode) {
                    textChannel.setSlowmode(slowmode);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateSlowmodeEvent(this.getJDA(), this.responseNumber, textChannel, oldSlowmode));
                }
                this.applyPermissions(textChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.getJDA(), this.responseNumber, textChannel, changed));
                break;
            }
            case VOICE: {
                VoiceChannelImpl voiceChannel = (VoiceChannelImpl)this.getJDA().getVoiceChannelMap().get(channelId);
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (voiceChannel == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a VoiceChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = voiceChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = voiceChannel.getName();
                int oldPosition = voiceChannel.getPositionRaw();
                int oldLimit = voiceChannel.getUserLimit();
                int oldBitrate = voiceChannel.getBitrate();
                if (!Objects.equals(oldName, name)) {
                    voiceChannel.setName(name);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateNameEvent(this.getJDA(), this.responseNumber, voiceChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    voiceChannel.setParent(parentId == null ? 0L : parentId);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateParentEvent(this.getJDA(), this.responseNumber, voiceChannel, parent));
                }
                if (oldPosition != position) {
                    voiceChannel.setPosition(position);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, voiceChannel, oldPosition));
                }
                if (oldLimit != userLimit) {
                    voiceChannel.setUserLimit(userLimit);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.getJDA(), this.responseNumber, voiceChannel, oldLimit));
                }
                if (oldBitrate != bitrate) {
                    voiceChannel.setBitrate(bitrate);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.getJDA(), this.responseNumber, voiceChannel, oldBitrate));
                }
                this.applyPermissions(voiceChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.getJDA(), this.responseNumber, voiceChannel, changed));
                break;
            }
            case CATEGORY: {
                CategoryImpl category = (CategoryImpl)this.getJDA().getCategoryById(channelId);
                if (category == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a Category that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                String oldName = category.getName();
                int oldPosition = category.getPositionRaw();
                if (!Objects.equals(oldName, name)) {
                    category.setName(name);
                    this.getJDA().getEventManager().handle(new CategoryUpdateNameEvent(this.getJDA(), this.responseNumber, category, oldName));
                }
                if (!Objects.equals(oldPosition, position)) {
                    category.setPosition(position);
                    this.getJDA().getEventManager().handle(new CategoryUpdatePositionEvent(this.getJDA(), this.responseNumber, category, oldPosition));
                }
                this.applyPermissions(category, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new CategoryUpdatePermissionsEvent(this.getJDA(), this.responseNumber, category, changed));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized channel type JSON: " + content);
            }
        }
        return null;
    }

    private long getIdLong(IPermissionHolder permHolder) {
        if (permHolder instanceof Member) {
            return ((Member)permHolder).getUser().getIdLong();
        }
        return ((Role)permHolder).getIdLong();
    }

    private void applyPermissions(AbstractChannelImpl<?> channel, JSONObject content, JSONArray permOverwrites, List<IPermissionHolder> contained, List<IPermissionHolder> changed) {
        for (int i = 0; i < permOverwrites.length(); ++i) {
            this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content, changed, contained);
        }
        TLongLinkedList toRemove = new TLongLinkedList();
        TLongObjectMap<PermissionOverride> overridesMap = channel.getOverrideMap();
        TDecorators.wrap(overridesMap.keySet()).stream().map(id -> this.mapPermissionHolder((long)id, channel.getGuild())).filter(Objects::nonNull).filter(permHolder -> !contained.contains(permHolder)).forEach(permHolder -> {
            changed.add((IPermissionHolder)permHolder);
            toRemove.add(this.getIdLong((IPermissionHolder)permHolder));
        });
        toRemove.forEach(id -> {
            overridesMap.remove(id);
            return true;
        });
    }

    private IPermissionHolder mapPermissionHolder(long id, Guild guild) {
        Role holder = guild.getRoleById(id);
        return holder == null ? guild.getMemberById(id) : holder;
    }

    private void handlePermissionOverride(JSONObject override, AbstractChannelImpl<?> channel, JSONObject content, List<IPermissionHolder> changedPermHolders, List<IPermissionHolder> containedPermHolders) {
        PermissionOverrideImpl permOverride;
        IMentionable permHolder;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "role": {
                permHolder = channel.getGuild().getRoleById(id);
                if (permHolder != null) break;
                this.getJDA().getEventCache().cache(EventCache.Type.ROLE, id, this.responseNumber, this.allContent, (a, b) -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! RoleId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            case "member": {
                permHolder = channel.getGuild().getMemberById(id);
                if (permHolder != null) break;
                this.getJDA().getEventCache().cache(EventCache.Type.USER, id, this.responseNumber, this.allContent, (a, b) -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for Member that doesn't exist in this Guild! MemberId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
        if ((permOverride = (PermissionOverrideImpl)channel.getOverrideMap().get(id)) == null) {
            this.getJDA().getEntityBuilder().createPermissionOverride(override, channel);
            changedPermHolders.add((IPermissionHolder)((Object)permHolder));
        } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
            permOverride.setAllow(allow);
            permOverride.setDeny(deny);
            changedPermHolders.add((IPermissionHolder)((Object)permHolder));
        }
        containedPermHolders.add((IPermissionHolder)((Object)permHolder));
    }

    private void handleGroup(JSONObject content) {
        long groupId = content.getLong("id");
        long ownerId = content.getLong("owner_id");
        String name = content.optString("name", null);
        String iconId = content.optString("icon", null);
        GroupImpl group = (GroupImpl)this.getJDA().asClient().getGroupById(groupId);
        if (group == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, groupId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received CHANNEL_UPDATE for a group that was not yet cached. JSON: {}", (Object)content);
            return;
        }
        User owner = group.getUserMap().get(ownerId);
        User oldOwner = group.getOwner();
        String oldName = group.getName();
        String oldIconId = group.getIconId();
        if (owner == null) {
            EventCache.LOG.warn("Received CHANNEL_UPDATE for a group with an owner_id for a user that is not cached. owner_id: {}", (Object)ownerId);
        } else if (!Objects.equals(owner, oldOwner)) {
            group.setOwner(owner);
            this.getJDA().getEventManager().handle(new GroupUpdateOwnerEvent(this.getJDA(), this.responseNumber, group, oldOwner));
        }
        if (!Objects.equals(name, oldName)) {
            group.setName(name);
            this.getJDA().getEventManager().handle(new GroupUpdateNameEvent(this.getJDA(), this.responseNumber, group, oldName));
        }
        if (!Objects.equals(iconId, oldIconId)) {
            group.setIconId(iconId);
            this.getJDA().getEventManager().handle(new GroupUpdateIconEvent(this.getJDA(), this.responseNumber, group, oldIconId));
        }
    }
}

