/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.guild.GuildBanEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.guild.GuildUnbanEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.JDALogger;
import ml.denis3d.repack.org.json.JSONObject;

public class GuildBanHandler
extends SocketHandler {
    private final boolean banned;

    public GuildBanHandler(JDAImpl api, boolean banned) {
        super(api);
        this.banned = banned;
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(id)) {
            return id;
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(id);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, id, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received Guild Member {} event for a Guild not yet cached.", JDALogger.getLazyString(() -> this.banned ? "Ban" : "Unban"));
            return null;
        }
        UserImpl user = this.getJDA().getEntityBuilder().createFakeUser(userJson, false);
        if (this.banned) {
            this.getJDA().getEventManager().handle(new GuildBanEvent(this.getJDA(), this.responseNumber, guild, user));
        } else {
            this.getJDA().getEventManager().handle(new GuildUnbanEvent(this.getJDA(), this.responseNumber, guild, user));
        }
        return null;
    }
}

