/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import java.util.LinkedList;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.MessageBulkDeleteEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.org.json.JSONObject;

public class MessageBulkDeleteHandler
extends SocketHandler {
    public MessageBulkDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("channel_id");
        if (this.getJDA().isBulkDeleteSplittingEnabled()) {
            SocketHandler handler = this.getJDA().getClient().getHandlers().get("MESSAGE_DELETE");
            content.getJSONArray("ids").forEach(id -> handler.handle(this.responseNumber, new JSONObject().put("t", "MESSAGE_DELETE").put("d", new JSONObject().put("channel_id", Long.toUnsignedString(channelId)).put("id", id))));
        } else {
            TextChannel channel = this.getJDA().getTextChannelMap().get(channelId);
            if (channel == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a Bulk Message Delete for a TextChannel that is not yet cached.");
                return null;
            }
            if (this.getJDA().getGuildSetupController().isLocked(channel.getGuild().getIdLong())) {
                return channel.getGuild().getIdLong();
            }
            LinkedList<String> msgIds = new LinkedList<String>();
            content.getJSONArray("ids").forEach(id -> msgIds.add((String)id));
            this.getJDA().getEventManager().handle(new MessageBulkDeleteEvent(this.getJDA(), this.responseNumber, channel, msgIds));
        }
        return null;
    }
}

