/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import ml.denis3d.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import ml.denis3d.repack.net.dv8tion.jda.client.events.message.group.GroupMessageDeleteEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.MessageDeleteEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageDeleteEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageDeleteEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.org.json.JSONObject;

public class MessageDeleteHandler
extends SocketHandler {
    public MessageDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long messageId = content.getLong("id");
        long channelId = content.getLong("channel_id");
        MessageChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelById(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.getJDA().getAccountType() == AccountType.CLIENT) {
            channel = this.getJDA().asClient().getGroupById(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Got message delete for a channel/group that is not yet cached. ChannelId: {}", (Object)channelId);
            return null;
        }
        if (channel instanceof TextChannel) {
            TextChannelImpl tChan = (TextChannelImpl)channel;
            if (this.getJDA().getGuildSetupController().isLocked(tChan.getGuild().getIdLong())) {
                return tChan.getGuild().getIdLong();
            }
            if (tChan.hasLatestMessage() && messageId == channel.getLatestMessageIdLong()) {
                tChan.setLastMessageId(0L);
            }
            this.getJDA().getEventManager().handle(new GuildMessageDeleteEvent(this.getJDA(), this.responseNumber, messageId, tChan));
        } else if (channel instanceof PrivateChannel) {
            PrivateChannelImpl pChan = (PrivateChannelImpl)channel;
            if (channel.hasLatestMessage() && messageId == channel.getLatestMessageIdLong()) {
                pChan.setLastMessageId(0L);
            }
            this.getJDA().getEventManager().handle(new PrivateMessageDeleteEvent(this.getJDA(), this.responseNumber, messageId, pChan));
        } else {
            GroupImpl group = (GroupImpl)channel;
            if (channel.hasLatestMessage() && messageId == channel.getLatestMessageIdLong()) {
                group.setLastMessageId(0L);
            }
            this.getJDA().getEventManager().handle(new GroupMessageDeleteEvent(this.getJDA(), this.responseNumber, messageId, group));
        }
        this.getJDA().getEventManager().handle(new MessageDeleteEvent(this.getJDA(), this.responseNumber, messageId, channel));
        return null;
    }
}

