/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import java.util.LinkedList;
import ml.denis3d.repack.net.dv8tion.jda.client.entities.Group;
import ml.denis3d.repack.net.dv8tion.jda.client.events.message.group.GroupMessageEmbedEvent;
import ml.denis3d.repack.net.dv8tion.jda.client.events.message.group.GroupMessageUpdateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.AccountType;
import ml.denis3d.repack.net.dv8tion.jda.core.JDA;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Message;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.MessageType;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.TextChannel;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.MessageEmbedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.MessageUpdateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageEmbedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageUpdateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageEmbedEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageUpdateEvent;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.EventCache;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import ml.denis3d.repack.org.json.JSONArray;
import ml.denis3d.repack.org.json.JSONObject;

public class MessageUpdateHandler
extends SocketHandler {
    public MessageUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        if (content.has("author")) {
            if (content.has("type")) {
                MessageType type = MessageType.fromId(content.getInt("type"));
                switch (type) {
                    case DEFAULT: {
                        return this.handleMessage(content);
                    }
                }
                WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: {} JSON: {}", (Object)type, (Object)content);
                return null;
            }
            this.handleMessageEmbed(content);
            return null;
        }
        if (content.has("call")) {
            this.handleCallMessage(content);
            return null;
        }
        return this.handleMessageEmbed(content);
    }

    private Long handleMessage(JSONObject content) {
        Message message;
        try {
            message = this.getJDA().getEntityBuilder().createMessage(content);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message update for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getJSONObject("author").getLong("id");
                    this.getJDA().getEventCache().cache(EventCache.Type.USER, authorId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message update for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        switch (message.getChannelType()) {
            case NEWS: 
            case TEXT: {
                TextChannel channel = message.getTextChannel();
                if (this.getJDA().getGuildSetupController().isLocked(channel.getGuild().getIdLong())) {
                    return channel.getGuild().getIdLong();
                }
                this.getJDA().getEventManager().handle(new GuildMessageUpdateEvent((JDA)this.getJDA(), this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                this.getJDA().getEventManager().handle(new PrivateMessageUpdateEvent(this.getJDA(), this.responseNumber, message));
                break;
            }
            case GROUP: {
                this.getJDA().getEventManager().handle(new GroupMessageUpdateEvent((JDA)this.getJDA(), this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_UPDATE with a unknown MessageChannel ChannelType. JSON: {}", (Object)content);
                return null;
            }
        }
        this.getJDA().getEventManager().handle(new MessageUpdateEvent(this.getJDA(), this.responseNumber, message));
        return null;
    }

    private Long handleMessageEmbed(JSONObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        long messageId = content.getLong("id");
        long channelId = content.getLong("channel_id");
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        MessageChannel channel = this.getJDA().getTextChannelMap().get(channelId);
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.getJDA().getAccountType() == AccountType.CLIENT) {
            channel = this.getJDA().asClient().getGroupById(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received message update for embeds for a channel/group that JDA does not have cached yet.");
            return null;
        }
        JSONArray embedsJson = content.getJSONArray("embeds");
        for (int i = 0; i < embedsJson.length(); ++i) {
            embeds.add(builder.createMessageEmbed(embedsJson.getJSONObject(i)));
        }
        if (channel instanceof TextChannel) {
            TextChannel tChannel = (TextChannel)channel;
            if (this.getJDA().getGuildSetupController().isLocked(tChannel.getGuild().getIdLong())) {
                return tChannel.getGuild().getIdLong();
            }
            this.getJDA().getEventManager().handle(new GuildMessageEmbedEvent(this.getJDA(), this.responseNumber, messageId, tChannel, embeds));
        } else if (channel instanceof PrivateChannel) {
            this.getJDA().getEventManager().handle(new PrivateMessageEmbedEvent(this.getJDA(), this.responseNumber, messageId, (PrivateChannel)channel, embeds));
        } else {
            this.getJDA().getEventManager().handle(new GroupMessageEmbedEvent(this.getJDA(), this.responseNumber, messageId, (Group)channel, embeds));
        }
        this.getJDA().getEventManager().handle(new MessageEmbedEvent(this.getJDA(), this.responseNumber, messageId, channel, embeds));
        return null;
    }

    public void handleCallMessage(JSONObject content) {
        WebSocketClient.LOG.debug("Received a MESSAGE_UPDATE of type CALL: {}", (Object)content);
    }
}

