/*
 * Decompiled with CFR 0.152.
 */
package ml.denis3d.repack.net.dv8tion.jda.core.handle;

import ml.denis3d.repack.net.dv8tion.jda.core.audio.AudioConnection;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.Guild;
import ml.denis3d.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.handle.SocketHandler;
import ml.denis3d.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import ml.denis3d.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import ml.denis3d.repack.net.dv8tion.jda.core.utils.MiscUtil;
import ml.denis3d.repack.org.json.JSONObject;

public class VoiceServerUpdateHandler
extends SocketHandler {
    public VoiceServerUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        Guild guild = this.getJDA().getGuildMap().get(guildId);
        if (guild == null) {
            throw new IllegalArgumentException("Attempted to start audio connection with Guild that doesn't exist!");
        }
        this.getJDA().getClient().updateAudioConnection(guildId, guild.getSelfMember().getVoiceState().getChannel());
        if (content.isNull("endpoint")) {
            return null;
        }
        String endpoint = content.getString("endpoint").replace(":80", "");
        String token = content.getString("token");
        String sessionId = guild.getSelfMember().getVoiceState().getSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Attempted to create audio connection without having a session ID. Did VOICE_STATE_UPDATED fail?");
        }
        AudioManagerImpl audioManager = (AudioManagerImpl)guild.getAudioManager();
        MiscUtil.locked(audioManager.CONNECTION_LOCK, () -> {
            if (audioManager.isConnected()) {
                audioManager.prepareForRegionChange();
            }
            if (!audioManager.isAttemptingToConnect()) {
                WebSocketClient.LOG.debug("Received a VOICE_SERVER_UPDATE but JDA is not currently connected nor attempted to connect to a VoiceChannel. Assuming that this is caused by another client running on this account. Ignoring the event.");
                return;
            }
            AudioConnection connection = new AudioConnection(audioManager, endpoint, sessionId, token);
            audioManager.setAudioConnection(connection);
            connection.startConnection();
        });
        return null;
    }
}

